/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlPositionExpression
extends BeamSqlExpression {
    public BeamSqlPositionExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.INTEGER);
    }

    @Override
    public boolean accept() {
        if (this.operands.size() < 2 || this.operands.size() > 3) {
            return false;
        }
        if (!SqlTypeName.CHAR_TYPES.contains((Object)this.opType(0)) || !SqlTypeName.CHAR_TYPES.contains((Object)this.opType(1))) {
            return false;
        }
        return this.operands.size() != 3 || SqlTypeName.INT_TYPES.contains((Object)this.opType(2));
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, ImmutableMap<Integer, Object> correlateEnv) {
        String targetStr = (String)this.opValueEvaluated(0, inputRow, window, correlateEnv);
        String containingStr = (String)this.opValueEvaluated(1, inputRow, window, correlateEnv);
        int from = -1;
        if (this.operands.size() == 3) {
            Number tmp = (Number)this.opValueEvaluated(2, inputRow, window, correlateEnv);
            from = tmp.intValue();
        }
        int idx = containingStr.indexOf(targetStr, from);
        return BeamSqlPrimitive.of(SqlTypeName.INTEGER, idx);
    }
}

