/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.comparison;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public abstract class BeamSqlCompareExpression
extends BeamSqlExpression {
    private BeamSqlCompareExpression(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        super(operands, outputType);
    }

    public BeamSqlCompareExpression(List<BeamSqlExpression> operands) {
        this(operands, SqlTypeName.BOOLEAN);
    }

    @Override
    public boolean accept() {
        return this.operands.size() == 2;
    }

    @Override
    public BeamSqlPrimitive<Boolean> evaluate(Row inputRow, BoundedWindow window, ImmutableMap<Integer, Object> correlateEnv) {
        Object leftValue = ((BeamSqlExpression)this.operands.get(0)).evaluate(inputRow, window, correlateEnv).getValue();
        Object rightValue = ((BeamSqlExpression)this.operands.get(1)).evaluate(inputRow, window, correlateEnv).getValue();
        switch (((BeamSqlExpression)this.operands.get(0)).getOutputType()) {
            case BIGINT: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: {
                return BeamSqlPrimitive.of(SqlTypeName.BOOLEAN, this.compare((Number)leftValue, (Number)rightValue));
            }
            case BOOLEAN: {
                return BeamSqlPrimitive.of(SqlTypeName.BOOLEAN, this.compare((Boolean)leftValue, (Boolean)rightValue));
            }
            case VARCHAR: {
                return BeamSqlPrimitive.of(SqlTypeName.BOOLEAN, this.compare((CharSequence)leftValue, (CharSequence)rightValue));
            }
        }
        throw new UnsupportedOperationException(this.toString());
    }

    public abstract Boolean compare(CharSequence var1, CharSequence var2);

    public abstract Boolean compare(Boolean var1, Boolean var2);

    public abstract Boolean compare(Number var1, Number var2);
}

