/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.array;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlArrayExpression
extends BeamSqlExpression {
    public BeamSqlArrayExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.ARRAY);
    }

    @Override
    public boolean accept() {
        return this.operands.stream().map(BeamSqlExpression::getOutputType).distinct().count() == 1L;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, ImmutableMap<Integer, Object> correlateEnv) {
        List elements = this.operands.stream().map(op -> op.evaluate(inputRow, window, correlateEnv).getValue()).collect(Collectors.toList());
        return BeamSqlPrimitive.of(this.outputType, elements);
    }
}

