/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlUdfExpression
extends BeamSqlExpression {
    private transient Method method;
    private transient Object udfIns;
    private String className;
    private String methodName;
    private List<String> paraClassName = new ArrayList<String>();

    public BeamSqlUdfExpression(Method method, List<BeamSqlExpression> subExps, SqlTypeName sqlTypeName) {
        super(subExps, sqlTypeName);
        this.method = method;
        this.className = method.getDeclaringClass().getName();
        this.methodName = method.getName();
        for (Class<?> c : method.getParameterTypes()) {
            this.paraClassName.add(c.getName());
        }
    }

    @Override
    public boolean accept() {
        return true;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, ImmutableMap<Integer, Object> correlateEnv) {
        if (this.method == null) {
            this.reConstructMethod();
        }
        try {
            ArrayList paras = new ArrayList();
            for (BeamSqlExpression e : this.getOperands()) {
                paras.add(e.evaluate(inputRow, window, correlateEnv).getValue());
            }
            return BeamSqlPrimitive.of(this.getOutputType(), this.method.invoke(this.udfIns, paras.toArray(new Object[0])));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void reConstructMethod() {
        try {
            ArrayList paraClass = new ArrayList();
            for (String pc : this.paraClassName) {
                paraClass.add(Class.forName(pc));
            }
            this.method = Class.forName(this.className).getMethod(this.methodName, paraClass.toArray(new Class[0]));
            if (!Modifier.isStatic(this.method.getModifiers())) {
                this.udfIns = Class.forName(this.className).newInstance();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

