/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlCorrelVariableExpression
extends BeamSqlExpression {
    private final int correlationId;

    public BeamSqlCorrelVariableExpression(SqlTypeName sqlTypeName, int correlationId) {
        super(null, sqlTypeName);
        this.correlationId = correlationId;
    }

    @Override
    public boolean accept() {
        return true;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, ImmutableMap<Integer, Object> correlateEnv) {
        Object correlateValue = correlateEnv.get(this.correlationId);
        Preconditions.checkState(correlateValue != null, "Correlation variables %s not found in environment %s", this.correlationId, correlateEnv);
        return BeamSqlPrimitive.of(this.getOutputType(), correlateValue);
    }
}

