/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate;

import java.util.ArrayList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.Lists;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlSyntax;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlAbstractGroupFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.AggFinder;

abstract class AggVisitor
extends SqlBasicVisitor<Void> {
    protected final SqlOperatorTable opTab;
    protected final boolean over;
    protected final AggFinder delegate;
    protected boolean aggregate;
    protected boolean group;

    AggVisitor(SqlOperatorTable opTab, boolean over, boolean aggregate, boolean group, AggFinder delegate) {
        this.group = group;
        this.over = over;
        this.aggregate = aggregate;
        this.delegate = delegate;
        this.opTab = opTab;
    }

    @Override
    public Void visit(SqlCall call) {
        SqlFunction sqlFunction;
        SqlOperator operator = call.getOperator();
        if (operator.isAggregator() && !(operator instanceof SqlAbstractGroupFunction) && !operator.requiresOver()) {
            if (this.delegate != null) {
                return operator.acceptCall(this.delegate, call);
            }
            if (this.aggregate) {
                return this.found(call);
            }
        }
        if (this.group && operator.isGroup()) {
            return this.found(call);
        }
        if (operator instanceof SqlFunction && (sqlFunction = (SqlFunction)operator).getFunctionType().isUserDefinedNotSpecificFunction()) {
            ArrayList<SqlOperator> list = Lists.newArrayList();
            this.opTab.lookupOperatorOverloads(sqlFunction.getSqlIdentifier(), sqlFunction.getFunctionType(), SqlSyntax.FUNCTION, list);
            for (SqlOperator operator2 : list) {
                if (!operator2.isAggregator() || operator2.requiresOver() || !this.aggregate) continue;
                this.found(call);
            }
        }
        if (call.isA(SqlKind.QUERY)) {
            return null;
        }
        if (call.getKind() == SqlKind.OVER) {
            if (this.over) {
                return this.found(call);
            }
            return null;
        }
        return (Void)super.visit(call);
    }

    protected abstract Void found(SqlCall var1);
}

