/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun;

import java.util.ArrayList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlTranslate3Function;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.OperandTypes;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.util.ReflectiveSqlOperatorTable;

public class OracleSqlOperatorTable
extends ReflectiveSqlOperatorTable {
    private static OracleSqlOperatorTable instance;
    protected static final SqlReturnTypeInference DECODE_RETURN_TYPE;
    public static final SqlFunction DECODE;
    public static final SqlFunction NVL;
    public static final SqlFunction LTRIM;
    public static final SqlFunction RTRIM;
    public static final SqlFunction SUBSTR;
    public static final SqlFunction GREATEST;
    public static final SqlFunction LEAST;
    public static final SqlFunction TRANSLATE3;

    public static synchronized OracleSqlOperatorTable instance() {
        if (instance == null) {
            instance = new OracleSqlOperatorTable();
            instance.init();
        }
        return instance;
    }

    static {
        DECODE_RETURN_TYPE = new SqlReturnTypeInference(){

            @Override
            public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
                ArrayList<RelDataType> list = new ArrayList<RelDataType>();
                int n = opBinding.getOperandCount();
                for (int i = 1; i < n; ++i) {
                    if (i < n - 1) {
                        ++i;
                    }
                    list.add(opBinding.getOperandType(i));
                }
                RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
                RelDataType type = typeFactory.leastRestrictive(list);
                if (opBinding.getOperandCount() % 2 == 1) {
                    type = typeFactory.createTypeWithNullability(type, true);
                }
                return type;
            }
        };
        DECODE = new SqlFunction("DECODE", SqlKind.DECODE, DECODE_RETURN_TYPE, null, OperandTypes.VARIADIC, SqlFunctionCategory.SYSTEM);
        NVL = new SqlFunction("NVL", SqlKind.NVL, ReturnTypes.cascade(ReturnTypes.LEAST_RESTRICTIVE, SqlTypeTransforms.TO_NULLABLE_ALL), null, OperandTypes.SAME_SAME, SqlFunctionCategory.SYSTEM);
        LTRIM = new SqlFunction("LTRIM", SqlKind.LTRIM, ReturnTypes.cascade(ReturnTypes.ARG0, SqlTypeTransforms.TO_NULLABLE, SqlTypeTransforms.TO_VARYING), null, OperandTypes.STRING, SqlFunctionCategory.STRING);
        RTRIM = new SqlFunction("RTRIM", SqlKind.RTRIM, ReturnTypes.cascade(ReturnTypes.ARG0, SqlTypeTransforms.TO_NULLABLE, SqlTypeTransforms.TO_VARYING), null, OperandTypes.STRING, SqlFunctionCategory.STRING);
        SUBSTR = new SqlFunction("SUBSTR", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, null, SqlFunctionCategory.STRING);
        GREATEST = new SqlFunction("GREATEST", SqlKind.GREATEST, ReturnTypes.cascade(ReturnTypes.LEAST_RESTRICTIVE, SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.SAME_VARIADIC, SqlFunctionCategory.SYSTEM);
        LEAST = new SqlFunction("LEAST", SqlKind.LEAST, ReturnTypes.cascade(ReturnTypes.LEAST_RESTRICTIVE, SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.SAME_VARIADIC, SqlFunctionCategory.SYSTEM);
        TRANSLATE3 = new SqlTranslate3Function();
    }
}

