/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.volcano;

import java.util.Objects;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCostFactory;

class VolcanoCost
implements RelOptCost {
    static final VolcanoCost INFINITY = new VolcanoCost(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY){

        @Override
        public String toString() {
            return "{inf}";
        }
    };
    static final VolcanoCost HUGE = new VolcanoCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE){

        @Override
        public String toString() {
            return "{huge}";
        }
    };
    static final VolcanoCost ZERO = new VolcanoCost(0.0, 0.0, 0.0){

        @Override
        public String toString() {
            return "{0}";
        }
    };
    static final VolcanoCost TINY = new VolcanoCost(1.0, 1.0, 0.0){

        @Override
        public String toString() {
            return "{tiny}";
        }
    };
    public static final RelOptCostFactory FACTORY = new Factory();
    final double cpu;
    final double io;
    final double rowCount;

    VolcanoCost(double rowCount, double cpu, double io) {
        this.rowCount = rowCount;
        this.cpu = cpu;
        this.io = io;
    }

    @Override
    public double getCpu() {
        return this.cpu;
    }

    @Override
    public boolean isInfinite() {
        return this == INFINITY || this.rowCount == Double.POSITIVE_INFINITY || this.cpu == Double.POSITIVE_INFINITY || this.io == Double.POSITIVE_INFINITY;
    }

    @Override
    public double getIo() {
        return this.io;
    }

    @Override
    public boolean isLe(RelOptCost other) {
        VolcanoCost that = (VolcanoCost)other;
        return this == that || this.rowCount <= that.rowCount;
    }

    @Override
    public boolean isLt(RelOptCost other) {
        VolcanoCost that = (VolcanoCost)other;
        return this.rowCount < that.rowCount;
    }

    @Override
    public double getRows() {
        return this.rowCount;
    }

    public int hashCode() {
        return Objects.hash(this.rowCount, this.cpu, this.io);
    }

    @Override
    public boolean equals(RelOptCost other) {
        return this == other || other instanceof VolcanoCost && this.rowCount == ((VolcanoCost)other).rowCount && this.cpu == ((VolcanoCost)other).cpu && this.io == ((VolcanoCost)other).io;
    }

    @Override
    public boolean isEqWithEpsilon(RelOptCost other) {
        if (!(other instanceof VolcanoCost)) {
            return false;
        }
        VolcanoCost that = (VolcanoCost)other;
        return this == that || Math.abs(this.rowCount - that.rowCount) < 1.0E-5 && Math.abs(this.cpu - that.cpu) < 1.0E-5 && Math.abs(this.io - that.io) < 1.0E-5;
    }

    @Override
    public RelOptCost minus(RelOptCost other) {
        if (this == INFINITY) {
            return this;
        }
        VolcanoCost that = (VolcanoCost)other;
        return new VolcanoCost(this.rowCount - that.rowCount, this.cpu - that.cpu, this.io - that.io);
    }

    @Override
    public RelOptCost multiplyBy(double factor) {
        if (this == INFINITY) {
            return this;
        }
        return new VolcanoCost(this.rowCount * factor, this.cpu * factor, this.io * factor);
    }

    @Override
    public double divideBy(RelOptCost cost) {
        VolcanoCost that = (VolcanoCost)cost;
        double d = 1.0;
        double n = 0.0;
        if (this.rowCount != 0.0 && !Double.isInfinite(this.rowCount) && that.rowCount != 0.0 && !Double.isInfinite(that.rowCount)) {
            d *= this.rowCount / that.rowCount;
            n += 1.0;
        }
        if (this.cpu != 0.0 && !Double.isInfinite(this.cpu) && that.cpu != 0.0 && !Double.isInfinite(that.cpu)) {
            d *= this.cpu / that.cpu;
            n += 1.0;
        }
        if (this.io != 0.0 && !Double.isInfinite(this.io) && that.io != 0.0 && !Double.isInfinite(that.io)) {
            d *= this.io / that.io;
            n += 1.0;
        }
        if (n == 0.0) {
            return 1.0;
        }
        return Math.pow(d, 1.0 / n);
    }

    @Override
    public RelOptCost plus(RelOptCost other) {
        VolcanoCost that = (VolcanoCost)other;
        if (this == INFINITY || that == INFINITY) {
            return INFINITY;
        }
        return new VolcanoCost(this.rowCount + that.rowCount, this.cpu + that.cpu, this.io + that.io);
    }

    @Override
    public String toString() {
        return "{" + this.rowCount + " rows, " + this.cpu + " cpu, " + this.io + " io}";
    }

    private static class Factory
    implements RelOptCostFactory {
        private Factory() {
        }

        @Override
        public RelOptCost makeCost(double dRows, double dCpu, double dIo) {
            return new VolcanoCost(dRows, dCpu, dIo);
        }

        @Override
        public RelOptCost makeHugeCost() {
            return HUGE;
        }

        @Override
        public RelOptCost makeInfiniteCost() {
            return INFINITY;
        }

        @Override
        public RelOptCost makeTinyCost() {
            return TINY;
        }

        @Override
        public RelOptCost makeZeroCost() {
            return ZERO;
        }
    }
}

