/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.cep;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPCall;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPFieldRef;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPKind;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPOperation;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPPattern;
import org.apache.beam.sdk.extensions.sql.impl.cep.OrderKey;
import org.apache.beam.sdk.extensions.sql.impl.cep.Quantifier;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelCollation;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelFieldCollation;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CEPUtils {
    private static @UnknownKeyFor @NonNull @Initialized Quantifier getQuantifier(@UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end, @UnknownKeyFor @NonNull @Initialized boolean isReluctant) {
        Quantifier quantToAdd = !isReluctant ? (start == end ? new Quantifier("{ " + start + " }") : (end == -1 ? (start == 0 ? Quantifier.ASTERISK : (start == 1 ? Quantifier.PLUS : new Quantifier("{ " + start + " }"))) : (start == 0 && end == 1 ? Quantifier.QMARK : (start == -1 ? new Quantifier("{ , " + end + " }") : new Quantifier("{ " + start + " , }"))))) : (start == end ? new Quantifier("{ " + start + " }?") : (end == -1 ? (start == 0 ? Quantifier.ASTERISK_RELUCTANT : (start == 1 ? Quantifier.PLUS_RELUCTANT : new Quantifier("{ " + start + " }?"))) : (start == 0 && end == 1 ? Quantifier.QMARK_RELUCTANT : (start == -1 ? new Quantifier("{ , " + end + " }?") : new Quantifier("{ " + start + " , }?")))));
        return quantToAdd;
    }

    public static @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized CEPPattern> getCEPPatternFromPattern(@UnknownKeyFor @NonNull @Initialized Schema upStreamSchema, @UnknownKeyFor @NonNull @Initialized RexNode call, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized RexNode> patternDefs) {
        ArrayList<CEPPattern> patternList = new ArrayList<CEPPattern>();
        if (call.getClass() == RexLiteral.class) {
            String p = (String)((RexLiteral)call).getValueAs(String.class);
            RexNode pd = patternDefs.get(p);
            patternList.add(CEPPattern.of(upStreamSchema, p, (RexCall)pd, Quantifier.NONE));
        } else {
            RexCall patCall = (RexCall)call;
            SqlOperator operator = patCall.getOperator();
            List operands = patCall.getOperands();
            if (operator.getKind() == SqlKind.PATTERN_QUANTIFIER) {
                String p = (String)((RexLiteral)operands.get(0)).getValueAs(String.class);
                RexNode pd = patternDefs.get(p);
                int start = (Integer)((RexLiteral)operands.get(1)).getValueAs(Integer.class);
                int end = (Integer)((RexLiteral)operands.get(2)).getValueAs(Integer.class);
                boolean isReluctant = (Boolean)((RexLiteral)operands.get(3)).getValueAs(Boolean.class);
                patternList.add(CEPPattern.of(upStreamSchema, p, (RexCall)pd, CEPUtils.getQuantifier(start, end, isReluctant)));
            } else {
                for (RexNode i : operands) {
                    patternList.addAll(CEPUtils.getCEPPatternFromPattern(upStreamSchema, i, patternDefs));
                }
            }
        }
        return patternList;
    }

    public static @UnknownKeyFor @NonNull @Initialized String getRegexFromPattern(@UnknownKeyFor @NonNull @Initialized RexNode call) {
        if (call.getClass() == RexLiteral.class) {
            return (String)((RexLiteral)call).getValueAs(String.class);
        }
        RexCall opr = (RexCall)call;
        SqlOperator operator = opr.getOperator();
        List operands = opr.getOperands();
        if (operator.getKind() == SqlKind.PATTERN_QUANTIFIER) {
            String p = (String)((RexLiteral)operands.get(0)).getValueAs(String.class);
            int start = (Integer)((RexLiteral)operands.get(1)).getValueAs(Integer.class);
            int end = (Integer)((RexLiteral)operands.get(2)).getValueAs(Integer.class);
            boolean isReluctant = (Boolean)((RexLiteral)operands.get(3)).getValueAs(Boolean.class);
            Quantifier quantifier = CEPUtils.getQuantifier(start, end, isReluctant);
            return p + quantifier.toString();
        }
        return CEPUtils.getRegexFromPattern((RexNode)opr.getOperands().get(0)) + CEPUtils.getRegexFromPattern((RexNode)opr.getOperands().get(1));
    }

    public static @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized OrderKey> makeOrderKeysFromCollation(@UnknownKeyFor @NonNull @Initialized RelCollation orderKeys) {
        List relOrderKeys = orderKeys.getFieldCollations();
        ArrayList<OrderKey> orderKeysList = new ArrayList<OrderKey>();
        for (RelFieldCollation i : relOrderKeys) {
            orderKeysList.add(OrderKey.of(i));
        }
        return orderKeysList;
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CEPFieldRef> getCEPFieldRefFromParKeys(@UnknownKeyFor @NonNull @Initialized ImmutableBitSet partitionKeys) {
        ArrayList<CEPFieldRef> fieldList = new ArrayList<CEPFieldRef>();
        Iterator iterator = partitionKeys.asList().iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            fieldList.add(new CEPFieldRef("Partition Key " + index, index));
        }
        return fieldList;
    }

    public static @UnknownKeyFor @NonNull @Initialized CEPFieldRef getFieldRef(@UnknownKeyFor @NonNull @Initialized CEPOperation opr) {
        if (opr.getClass() == CEPFieldRef.class) {
            CEPFieldRef field = (CEPFieldRef)opr;
            return field;
        }
        if (opr.getClass() == CEPCall.class) {
            CEPCall call = (CEPCall)opr;
            for (CEPOperation i : call.getOperands()) {
                CEPFieldRef field = CEPUtils.getFieldRef(i);
                if (field == null) continue;
                return field;
            }
            return null;
        }
        return null;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType getFieldType(@UnknownKeyFor @NonNull @Initialized Schema streamSchema, @UnknownKeyFor @NonNull @Initialized CEPOperation measureOperation) {
        if (measureOperation.getClass() == CEPFieldRef.class) {
            CEPFieldRef field = (CEPFieldRef)measureOperation;
            return streamSchema.getField(field.getIndex()).getType();
        }
        if (measureOperation.getClass() == CEPCall.class) {
            CEPCall call = (CEPCall)measureOperation;
            CEPKind oprKind = call.getOperator().getCepKind();
            if (oprKind == CEPKind.SUM || oprKind == CEPKind.COUNT) {
                return Schema.FieldType.INT32;
            }
            if (oprKind == CEPKind.AVG) {
                return Schema.FieldType.DOUBLE;
            }
            for (CEPOperation i : call.getOperands()) {
                CEPFieldRef refOpt = CEPUtils.getFieldRef(i);
                if (refOpt == null) continue;
                return streamSchema.getField(refOpt.getIndex()).getType();
            }
            throw new UnsupportedOperationException("the function in Measures is not recognized.");
        }
        throw new UnsupportedOperationException("the function in Measures is not recognized.");
    }
}

