/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.DefaultTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.ProjectSupport;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamBigQuerySqlDialect;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamSqlUnparseContext;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryFilter;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
class BigQueryTable
extends SchemaBaseBeamTable
implements Serializable {
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String METHOD_PROPERTY = "method";
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String WRITE_DISPOSITION_PROPERTY = "writeDisposition";
    @VisibleForTesting
    final @UnknownKeyFor @NonNull @Initialized String bqLocation;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigQueryUtils.ConversionOptions conversionOptions;
    private @UnknownKeyFor @NonNull @Initialized BeamTableStatistics rowCountStatistics = null;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryTable.class);
    @VisibleForTesting
    final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.Method method;
    @VisibleForTesting
    final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition writeDisposition;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    BigQueryTable(@UnknownKeyFor @NonNull @Initialized Table table, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigQueryUtils.ConversionOptions options) {
        super(table.getSchema());
        this.conversionOptions = options;
        this.bqLocation = table.getLocation();
        if (table.getProperties().containsKey((Object)METHOD_PROPERTY)) {
            String selectedMethod;
            List validMethods = Arrays.stream(BigQueryIO.TypedRead.Method.values()).map(Enum::toString).collect(Collectors.toList());
            if (!validMethods.contains(selectedMethod = table.getProperties().getString(METHOD_PROPERTY).toUpperCase())) throw new InvalidPropertyException("Invalid method '" + selectedMethod + "'. Supported methods are: " + validMethods.toString() + ".");
            this.method = BigQueryIO.TypedRead.Method.valueOf((String)selectedMethod);
        } else {
            this.method = BigQueryIO.TypedRead.Method.DIRECT_READ;
        }
        LOG.info("BigQuery method is set to: {}", (Object)this.method);
        if (table.getProperties().containsKey((Object)WRITE_DISPOSITION_PROPERTY)) {
            String selectedWriteDisposition;
            List validWriteDispositions = Arrays.stream(BigQueryIO.Write.WriteDisposition.values()).map(Enum::toString).collect(Collectors.toList());
            if (!validWriteDispositions.contains(selectedWriteDisposition = table.getProperties().getString(WRITE_DISPOSITION_PROPERTY).toUpperCase())) throw new InvalidPropertyException("Invalid write disposition '" + selectedWriteDisposition + "'. Supported write dispositions are: " + validWriteDispositions.toString() + ".");
            this.writeDisposition = BigQueryIO.Write.WriteDisposition.valueOf((String)selectedWriteDisposition);
        } else {
            this.writeDisposition = BigQueryIO.Write.WriteDisposition.WRITE_EMPTY;
        }
        LOG.info("BigQuery writeDisposition is set to: {}", (Object)this.writeDisposition);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamTableStatistics getTableStatistics(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        if (this.rowCountStatistics == null) {
            this.rowCountStatistics = BigQueryTable.getRowCountFromBQ(options, this.bqLocation);
        }
        return this.rowCountStatistics;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
        return (PCollection)begin.apply("Read Input BQ Rows", this.getBigQueryTypedRead(this.getSchema()));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin, @UnknownKeyFor @NonNull @Initialized BeamSqlTableFilter filters, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fieldNames) {
        String rowRestriction;
        BigQueryFilter bigQueryFilter;
        if (!this.method.equals((Object)BigQueryIO.TypedRead.Method.DIRECT_READ)) {
            LOG.info("Predicate/project push-down only available for `DIRECT_READ` method, skipping.");
            return this.buildIOReader(begin);
        }
        FieldAccessDescriptor resolved = FieldAccessDescriptor.withFieldNames(fieldNames).resolve(this.getSchema());
        Schema newSchema = SelectHelpers.getOutputSchema((Schema)this.getSchema(), (FieldAccessDescriptor)resolved);
        BigQueryIO.TypedRead typedRead = this.getBigQueryTypedRead(newSchema);
        if (!(filters instanceof DefaultTableFilter || (bigQueryFilter = (BigQueryFilter)filters).getSupported().isEmpty() || (rowRestriction = this.generateRowRestrictions(this.getSchema(), bigQueryFilter.getSupported())).isEmpty())) {
            LOG.info("Pushing down the following filter: {}", (Object)rowRestriction);
            typedRead = typedRead.withRowRestriction(rowRestriction);
        }
        if (!fieldNames.isEmpty()) {
            typedRead = typedRead.withSelectedFields(fieldNames);
        }
        return (PCollection)begin.apply("Read Input BQ Rows with push-down", (PTransform)typedRead);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized POutput buildIOWriter(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
        return input.apply((PTransform)BigQueryIO.write().withSchema(BigQueryUtils.toTableSchema((Schema)this.getSchema())).withFormatFunction(BigQueryUtils.toTableRow()).withWriteDisposition(this.writeDisposition).to(this.bqLocation));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ProjectSupport supportsProjects() {
        return this.method.equals((Object)BigQueryIO.TypedRead.Method.DIRECT_READ) ? ProjectSupport.WITHOUT_FIELD_REORDERING : ProjectSupport.NONE;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamSqlTableFilter constructFilter(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> filter) {
        if (this.method.equals((Object)BigQueryIO.TypedRead.Method.DIRECT_READ)) {
            return new BigQueryFilter(filter);
        }
        return super.constructFilter(filter);
    }

    private @UnknownKeyFor @NonNull @Initialized String generateRowRestrictions(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> supported) {
        assert (!supported.isEmpty());
        IntFunction<SqlNode> field = i -> new SqlIdentifier(schema.getField(i).getName(), SqlParserPos.ZERO);
        BeamSqlUnparseContext context = new BeamSqlUnparseContext(field);
        SqlNode andSqlNode = null;
        for (RexNode node : supported) {
            SqlNode sqlNode = context.toSql(null, node);
            if (andSqlNode == null) {
                andSqlNode = sqlNode;
                continue;
            }
            andSqlNode = SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, (List)ImmutableList.of((Object)andSqlNode, (Object)sqlNode));
        }
        return andSqlNode.toSqlString(BeamBigQuerySqlDialect.DEFAULT).getSql();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead<@UnknownKeyFor @NonNull @Initialized Row> getBigQueryTypedRead(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return BigQueryIO.read((SerializableFunction & Serializable)record -> BigQueryUtils.toBeamRow((GenericRecord)record.getRecord(), (Schema)schema, (BigQueryUtils.ConversionOptions)this.conversionOptions)).withMethod(this.method).from(this.bqLocation).withCoder((Coder)SchemaCoder.of((Schema)schema));
    }

    private static @UnknownKeyFor @NonNull @Initialized BeamTableStatistics getRowCountFromBQ(@UnknownKeyFor @NonNull @Initialized PipelineOptions o, @UnknownKeyFor @NonNull @Initialized String bqLocation) {
        try {
            BigInteger rowCount = BigQueryHelpers.getNumRows((BigQueryOptions)((BigQueryOptions)o.as(BigQueryOptions.class)), (TableReference)BigQueryHelpers.parseTableSpec((String)bqLocation));
            if (rowCount == null) {
                return BeamTableStatistics.BOUNDED_UNKNOWN;
            }
            return BeamTableStatistics.createBoundedTableStatistics(rowCount.doubleValue());
        }
        catch (IOException | InterruptedException e) {
            LOG.warn("Could not get the row count for the table " + bqLocation, (Throwable)e);
            return BeamTableStatistics.BOUNDED_UNKNOWN;
        }
    }

    public static class InvalidPropertyException
    extends UnsupportedOperationException {
        private InvalidPropertyException(@UnknownKeyFor @NonNull @Initialized String s) {
            super(s);
        }
    }
}

