/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.BaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.DefaultTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.ProjectSupport;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.InvalidTableException;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.ProjectionProducer;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.InvalidConfigurationException;
import org.apache.beam.sdk.schemas.io.InvalidSchemaException;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.RowJson;
import org.apache.beam.sdk.util.RowJsonUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@Experimental
public abstract class SchemaIOTableProviderWrapper
extends InMemoryMetaTableProvider
implements Serializable {
    public abstract @UnknownKeyFor @NonNull @Initialized SchemaIOProvider getSchemaIOProvider();

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTableType() {
        return this.getSchemaIOProvider().identifier();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamSqlTable buildBeamSqlTable(@UnknownKeyFor @NonNull @Initialized Table tableDefinition) {
        JSONObject tableProperties = tableDefinition.getProperties();
        try {
            RowJson.RowJsonDeserializer deserializer = RowJson.RowJsonDeserializer.forSchema((Schema)this.getSchemaIOProvider().configurationSchema()).withNullBehavior(RowJson.RowJsonDeserializer.NullBehavior.ACCEPT_MISSING_OR_NULL);
            Row configurationRow = (Row)RowJsonUtils.newObjectMapperWith((RowJson.RowJsonDeserializer)deserializer).readValue(tableProperties.toString(), Row.class);
            SchemaIO schemaIO = this.getSchemaIOProvider().from(tableDefinition.getLocation(), configurationRow, tableDefinition.getSchema());
            return new SchemaIOTableWrapper(schemaIO);
        }
        catch (InvalidConfigurationException | InvalidSchemaException e) {
            throw new InvalidTableException(e.getMessage());
        }
        catch (JsonProcessingException e) {
            throw new AssertionError((Object)("Failed to re-parse TBLPROPERTIES JSON " + tableProperties.toString()));
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized BeamTableStatistics getTableStatistics(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized SchemaIO schemaIO) {
        if (this.isBounded().equals((Object)PCollection.IsBounded.BOUNDED)) {
            return BeamTableStatistics.BOUNDED_UNKNOWN;
        }
        return BeamTableStatistics.UNBOUNDED_UNKNOWN;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return this.getSchemaIOProvider().isBounded();
    }

    private class SchemaIOTableWrapper
    extends BaseBeamTable {
        protected final @UnknownKeyFor @NonNull @Initialized SchemaIO schemaIO;

        private SchemaIOTableWrapper(SchemaIO schemaIO) {
            this.schemaIO = schemaIO;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
            return SchemaIOTableProviderWrapper.this.isBounded();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
            return this.schemaIO.schema();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
            PTransform readerTransform = this.schemaIO.buildReader();
            return (PCollection)begin.apply(readerTransform);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin, @UnknownKeyFor @NonNull @Initialized BeamSqlTableFilter filters, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fieldNames) {
            PTransform readerTransform = this.schemaIO.buildReader();
            if (!(filters instanceof DefaultTableFilter)) {
                throw new UnsupportedOperationException(String.format("Filter pushdown is not yet supported in %s. https://github.com/apache/beam/issues/21001", SchemaIOTableWrapper.class));
            }
            if (!fieldNames.isEmpty()) {
                if (readerTransform instanceof ProjectionProducer) {
                    ProjectionProducer projectionProducer = (ProjectionProducer)readerTransform;
                    FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptor.withFieldNames(fieldNames);
                    readerTransform = (PTransform)projectionProducer.actuateProjectionPushdown((Map)ImmutableMap.of((Object)new TupleTag("output"), (Object)fieldAccessDescriptor));
                } else {
                    throw new UnsupportedOperationException(String.format("%s does not support projection pushdown.", this.getClass()));
                }
            }
            return (PCollection)begin.apply(readerTransform);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ProjectSupport supportsProjects() {
            PTransform readerTransform = this.schemaIO.buildReader();
            if (readerTransform instanceof ProjectionProducer && ((ProjectionProducer)readerTransform).supportsProjectionPushdown()) {
                return ProjectSupport.WITH_FIELD_REORDERING;
            }
            return ProjectSupport.NONE;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized POutput buildIOWriter(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
            PTransform writerTransform = this.schemaIO.buildWriter();
            return input.apply(writerTransform);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BeamTableStatistics getTableStatistics(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return SchemaIOTableProviderWrapper.this.getTableStatistics(options, this.schemaIO);
        }
    }
}

