/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import com.alibaba.fastjson.JSONObject;
import com.google.auto.service.AutoService;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={TableProvider.class})
public class BigQueryTableProvider
extends InMemoryMetaTableProvider {
    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTableType() {
        return "bigquery";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamSqlTable buildBeamSqlTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        return new BigQueryTable(table, BigQueryTableProvider.getConversionOptions(table.getProperties()));
    }

    protected static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BigQueryUtils.ConversionOptions getConversionOptions(@UnknownKeyFor @NonNull @Initialized JSONObject properties) {
        return BigQueryUtils.ConversionOptions.builder().setTruncateTimestamps((Boolean)MoreObjects.firstNonNull((Object)properties.getBoolean("truncateTimestamps"), (Object)false) != false ? BigQueryUtils.ConversionOptions.TruncateTimestamps.TRUNCATE : BigQueryUtils.ConversionOptions.TruncateTimestamps.REJECT).build();
    }
}

