/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import java.io.IOException;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.TextRowCountEstimator;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class TextTable
extends SchemaBaseBeamTable {
    private final @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> readConverter;
    private final @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String>> writeConverter;
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TextRowCountEstimator.SamplingStrategy DEFAULT_SAMPLING_STRATEGY = new TextRowCountEstimator.LimitNumberOfTotalBytes(0x100000L);
    private final @UnknownKeyFor @NonNull @Initialized String filePattern;
    private @UnknownKeyFor @NonNull @Initialized BeamTableStatistics rowCountStatistics = null;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TextTable.class);

    public TextTable(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized String filePattern, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> readConverter, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String>> writeConverter) {
        super(schema);
        this.filePattern = filePattern;
        this.readConverter = readConverter;
        this.writeConverter = writeConverter;
    }

    public @UnknownKeyFor @NonNull @Initialized String getFilePattern() {
        return this.filePattern;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamTableStatistics getTableStatistics(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        if (this.rowCountStatistics == null) {
            this.rowCountStatistics = TextTable.getTextRowEstimate(options, this.getFilePattern());
        }
        return this.rowCountStatistics;
    }

    private static @UnknownKeyFor @NonNull @Initialized BeamTableStatistics getTextRowEstimate(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized String filePattern) {
        TextRowCountEstimator textRowCountEstimator = TextRowCountEstimator.builder().setFilePattern(filePattern).setSamplingStrategy(DEFAULT_SAMPLING_STRATEGY).build();
        try {
            Double rows = textRowCountEstimator.estimateRowCount(options);
            return BeamTableStatistics.createBoundedTableStatistics(rows);
        }
        catch (IOException | TextRowCountEstimator.NoEstimationException e) {
            LOG.warn("Could not get the row count for the text table " + filePattern, e);
            return BeamTableStatistics.BOUNDED_UNKNOWN;
        }
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
        return (PCollection)((PCollection)begin.apply("ReadTextFiles", (PTransform)TextIO.read().from(this.filePattern))).apply("StringToRow", this.readConverter);
    }

    public @UnknownKeyFor @NonNull @Initialized PDone buildIOWriter(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
        return (PDone)((PCollection)input.apply("RowToString", this.writeConverter)).apply("WriteTextFiles", (PTransform)TextIO.write().withDelimiter(new char[0]).to(this.filePattern));
    }
}

