/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexDynamicParam;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexFieldAccess;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexLocalRef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexProgram;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexShuttle;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexUtil;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexVisitor;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexVisitorImpl;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.RelBuilder;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Litmus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Util;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.graph.DirectedGraph;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.graph.TopologicalOrderIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Ints;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;

public class CalcRelSplitter {
    private static final @UnknownKeyFor @NonNull @Initialized Logger RULE_LOGGER = RelOptPlanner.LOGGER;
    protected final @UnknownKeyFor @NonNull @Initialized RexProgram program;
    private final @UnknownKeyFor @NonNull @Initialized RelDataTypeFactory typeFactory;
    private final @UnknownKeyFor @NonNull @Initialized RelType @UnknownKeyFor @NonNull @Initialized [] relTypes;
    private final @UnknownKeyFor @NonNull @Initialized RelOptCluster cluster;
    private final @UnknownKeyFor @NonNull @Initialized RelTraitSet traits;
    private final @UnknownKeyFor @NonNull @Initialized RelNode child;
    protected final @UnknownKeyFor @NonNull @Initialized RelBuilder relBuilder;

    public CalcRelSplitter(@UnknownKeyFor @NonNull @Initialized Calc calc, @UnknownKeyFor @NonNull @Initialized RelBuilder relBuilder, @UnknownKeyFor @NonNull @Initialized RelType @UnknownKeyFor @NonNull @Initialized [] relTypes) {
        this.relBuilder = relBuilder;
        for (int i = 0; i < relTypes.length; ++i) {
            assert (relTypes[i] != null);
            for (int j = 0; j < i; ++j) {
                assert (relTypes[i] != relTypes[j]) : "Rel types must be distinct";
            }
        }
        this.program = calc.getProgram();
        this.cluster = calc.getCluster();
        this.traits = calc.getTraitSet();
        this.typeFactory = calc.getCluster().getTypeFactory();
        this.child = calc.getInput();
        this.relTypes = relTypes;
    }

    public @UnknownKeyFor @NonNull @Initialized RelNode execute() {
        assert (this.program.isValid(Litmus.THROW, null));
        List exprList = this.program.getExprList();
        RexNode[] exprs = exprList.toArray(new RexNode[0]);
        assert (!RexUtil.containComplexExprs((List)exprList));
        int[] exprLevels = new int[exprs.length];
        int[] levelTypeOrdinals = new int[exprs.length];
        int levelCount = this.chooseLevels(exprs, -1, exprLevels, levelTypeOrdinals);
        int[] exprMaxUsingLevelOrdinals = new HighestUsageFinder(exprs, exprLevels).getMaxUsingLevelOrdinals();
        List projectRefList = this.program.getProjectList();
        RexLocalRef conditionRef = this.program.getCondition();
        for (RexLocalRef projectRef : projectRefList) {
            exprMaxUsingLevelOrdinals[projectRef.getIndex()] = levelCount;
        }
        if (conditionRef != null) {
            exprMaxUsingLevelOrdinals[conditionRef.getIndex()] = levelCount;
        }
        if (RULE_LOGGER.isTraceEnabled()) {
            this.traceLevelExpressions(exprs, exprLevels, levelTypeOrdinals, levelCount);
        }
        RelNode rel = this.child;
        int inputFieldCount = this.program.getInputRowType().getFieldCount();
        int[] inputExprOrdinals = CalcRelSplitter.identityArray(inputFieldCount);
        boolean doneCondition = false;
        for (int level = 0; level < levelCount; ++level) {
            int[] projectExprOrdinals;
            RelDataType outputRowType;
            if (level == levelCount - 1) {
                outputRowType = this.program.getOutputRowType();
                projectExprOrdinals = new int[projectRefList.size()];
                for (int i = 0; i < projectExprOrdinals.length; ++i) {
                    projectExprOrdinals[i] = ((RexLocalRef)projectRefList.get(i)).getIndex();
                }
            } else {
                outputRowType = null;
                ArrayList<Integer> projectExprOrdinalList = new ArrayList<Integer>();
                for (int i = 0; i < exprs.length; ++i) {
                    RexNode expr = exprs[i];
                    if (expr instanceof RexLiteral) {
                        exprLevels[i] = -1;
                        continue;
                    }
                    if (exprLevels[i] > level || exprMaxUsingLevelOrdinals[i] <= level) continue;
                    projectExprOrdinalList.add(i);
                }
                projectExprOrdinals = Ints.toArray(projectExprOrdinalList);
            }
            RelType relType = this.relTypes[levelTypeOrdinals[level]];
            int conditionExprOrdinal = -1;
            if (conditionRef != null && !doneCondition) {
                conditionExprOrdinal = conditionRef.getIndex();
                if (exprLevels[conditionExprOrdinal] > level || !relType.supportsCondition()) {
                    conditionExprOrdinal = -1;
                } else {
                    doneCondition = true;
                }
            }
            RexProgram program1 = this.createProgramForLevel(level, levelCount, rel.getRowType(), exprs, exprLevels, inputExprOrdinals, projectExprOrdinals, conditionExprOrdinal, outputRowType);
            rel = relType.makeRel(this.cluster, this.traits, this.relBuilder, rel, program1);
            rel = this.handle(rel);
            inputExprOrdinals = projectExprOrdinals;
        }
        Preconditions.checkArgument((doneCondition || conditionRef == null ? 1 : 0) != 0, (Object)"unhandled condition");
        return rel;
    }

    protected @UnknownKeyFor @NonNull @Initialized RelNode handle(@UnknownKeyFor @NonNull @Initialized RelNode rel) {
        return rel;
    }

    private @UnknownKeyFor @NonNull @Initialized int chooseLevels(@UnknownKeyFor @NonNull @Initialized RexNode @UnknownKeyFor @NonNull @Initialized [] exprs, @UnknownKeyFor @NonNull @Initialized int conditionOrdinal, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] exprLevels, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] levelTypeOrdinals) {
        int inputFieldCount = this.program.getInputRowType().getFieldCount();
        int levelCount = 0;
        MaxInputFinder maxInputFinder = new MaxInputFinder(exprLevels);
        boolean[] relTypesPossibleForTopLevel = new boolean[this.relTypes.length];
        Arrays.fill(relTypesPossibleForTopLevel, true);
        List<Set<Integer>> cohorts = this.getCohorts();
        List<Integer> permutation = CalcRelSplitter.computeTopologicalOrdering(exprs, cohorts);
        block0: for (int i : permutation) {
            boolean condition;
            RexNode expr = exprs[i];
            boolean bl = condition = i == conditionOrdinal;
            if (i < inputFieldCount) {
                assert (expr instanceof RexInputRef);
                exprLevels[i] = -1;
                continue;
            }
            int level = maxInputFinder.maxInputFor(expr);
            Set<Integer> cohort = CalcRelSplitter.findCohort(cohorts, i);
            if (cohort != null) {
                for (Integer exprOrdinal : cohort) {
                    RexNode cohortExpr;
                    int cohortLevel;
                    if (exprOrdinal == i || (cohortLevel = maxInputFinder.maxInputFor(cohortExpr = exprs[exprOrdinal])) <= level) continue;
                    level = cohortLevel;
                }
            }
            while (true) {
                if (level >= levelCount) {
                    for (int relTypeOrdinal = 0; relTypeOrdinal < this.relTypes.length; ++relTypeOrdinal) {
                        int j;
                        if (!relTypesPossibleForTopLevel[relTypeOrdinal] || !this.relTypes[relTypeOrdinal].canImplement(expr, condition)) continue;
                        exprLevels[i] = level;
                        levelTypeOrdinals[level] = relTypeOrdinal;
                        assert (level == 0 || levelTypeOrdinals[level - 1] != levelTypeOrdinals[level]) : "successive levels of same type";
                        for (j = 0; j < relTypeOrdinal; ++j) {
                            relTypesPossibleForTopLevel[j] = false;
                        }
                        for (j = relTypeOrdinal + 1; j < this.relTypes.length; ++j) {
                            if (!relTypesPossibleForTopLevel[j]) continue;
                            relTypesPossibleForTopLevel[j] = this.relTypes[j].canImplement(expr, condition);
                        }
                        levelTypeOrdinals[levelCount] = CalcRelSplitter.firstSet(relTypesPossibleForTopLevel);
                        ++levelCount;
                        Arrays.fill(relTypesPossibleForTopLevel, true);
                        continue block0;
                    }
                    if (CalcRelSplitter.count(relTypesPossibleForTopLevel) >= this.relTypes.length) {
                        throw new AssertionError((Object)("cannot implement " + expr));
                    }
                    levelTypeOrdinals[levelCount] = CalcRelSplitter.firstSet(relTypesPossibleForTopLevel);
                    ++levelCount;
                    Arrays.fill(relTypesPossibleForTopLevel, true);
                } else {
                    int levelTypeOrdinal = levelTypeOrdinals[level];
                    if (this.relTypes[levelTypeOrdinal].canImplement(expr, condition)) {
                        exprLevels[i] = level;
                        continue block0;
                    }
                }
                ++level;
            }
        }
        if (levelCount == 0) {
            levelCount = 1;
        }
        return levelCount;
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> computeTopologicalOrdering(@UnknownKeyFor @NonNull @Initialized RexNode @UnknownKeyFor @NonNull @Initialized [] exprs, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer>> cohorts) {
        int i;
        DefaultDirectedGraph graph = DefaultDirectedGraph.create();
        for (i = 0; i < exprs.length; ++i) {
            graph.addVertex((Object)i);
        }
        for (i = 0; i < exprs.length; ++i) {
            RexNode expr = exprs[i];
            Set<Integer> cohort = CalcRelSplitter.findCohort(cohorts, i);
            final Set<Integer> targets = cohort == null ? Collections.singleton(i) : cohort;
            expr.accept((RexVisitor)new RexVisitorImpl<Void>(true, (DirectedGraph)graph){
                final /* synthetic */ DirectedGraph val$graph;
                {
                    this.val$graph = directedGraph;
                    super(deep);
                }

                public @UnknownKeyFor @Nullable @Initialized Void visitLocalRef(@UnknownKeyFor @NonNull @Initialized RexLocalRef localRef) {
                    for (Integer target : targets) {
                        this.val$graph.addEdge((Object)localRef.getIndex(), (Object)target);
                    }
                    return null;
                }
            });
        }
        TopologicalOrderIterator iter = new TopologicalOrderIterator((DirectedGraph)graph);
        ArrayList<Integer> permutation = new ArrayList<Integer>();
        while (iter.hasNext()) {
            permutation.add((Integer)iter.next());
        }
        return permutation;
    }

    private static @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer> findCohort(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer>> cohorts, @UnknownKeyFor @NonNull @Initialized int ordinal) {
        for (Set<Integer> cohort : cohorts) {
            if (!cohort.contains(ordinal)) continue;
            return cohort;
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] identityArray(@UnknownKeyFor @NonNull @Initialized int length) {
        int[] ints = new int[length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = i;
        }
        return ints;
    }

    private @UnknownKeyFor @NonNull @Initialized RexProgram createProgramForLevel(@UnknownKeyFor @NonNull @Initialized int level, @UnknownKeyFor @NonNull @Initialized int levelCount, @UnknownKeyFor @NonNull @Initialized RelDataType inputRowType, @UnknownKeyFor @NonNull @Initialized RexNode @UnknownKeyFor @NonNull @Initialized [] allExprs, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] exprLevels, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] inputExprOrdinals, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] projectExprOrdinals, @UnknownKeyFor @NonNull @Initialized int conditionExprOrdinal, @Nullable @UnknownKeyFor @Initialized RelDataType outputRowType) {
        RexLocalRef conditionRef;
        ArrayList<Object> exprs = new ArrayList<Object>();
        int[] exprInverseOrdinals = new int[allExprs.length];
        Arrays.fill(exprInverseOrdinals, -1);
        int j = 0;
        for (int i = 0; i < inputExprOrdinals.length; ++i) {
            int inputExprOrdinal = inputExprOrdinals[i];
            exprs.add(new RexInputRef(i, allExprs[inputExprOrdinal].getType()));
            exprInverseOrdinals[inputExprOrdinal] = j++;
        }
        InputToCommonExprConverter shuttle = new InputToCommonExprConverter(exprInverseOrdinals, exprLevels, level, inputExprOrdinals, allExprs);
        for (int i = 0; i < allExprs.length; ++i) {
            if (exprLevels[i] != level && (exprLevels[i] != -1 || level != levelCount - 1 || !(allExprs[i] instanceof RexLiteral))) continue;
            RexNode expr = allExprs[i];
            RexNode translatedExpr = (RexNode)expr.accept((RexVisitor)shuttle);
            exprs.add(translatedExpr);
            assert (exprInverseOrdinals[i] == -1);
            exprInverseOrdinals[i] = j++;
        }
        ArrayList<RexLocalRef> projectRefs = new ArrayList<RexLocalRef>(projectExprOrdinals.length);
        ArrayList<String> fieldNames = new ArrayList<String>(projectExprOrdinals.length);
        for (int i = 0; i < projectExprOrdinals.length; ++i) {
            int projectExprOrdinal = projectExprOrdinals[i];
            int index = exprInverseOrdinals[projectExprOrdinal];
            assert (index >= 0);
            RexNode expr = allExprs[projectExprOrdinal];
            projectRefs.add(new RexLocalRef(index, expr.getType()));
            fieldNames.add(this.deriveFieldName(expr, i));
        }
        if (conditionExprOrdinal >= 0) {
            int index = exprInverseOrdinals[conditionExprOrdinal];
            conditionRef = new RexLocalRef(index, allExprs[conditionExprOrdinal].getType());
        } else {
            conditionRef = null;
        }
        if (outputRowType == null) {
            outputRowType = RexUtil.createStructType((RelDataTypeFactory)this.typeFactory, projectRefs, fieldNames, null);
        }
        RexProgram program = new RexProgram(inputRowType, exprs, projectRefs, conditionRef, outputRowType);
        return program;
    }

    private @UnknownKeyFor @NonNull @Initialized String deriveFieldName(@UnknownKeyFor @NonNull @Initialized RexNode expr, @UnknownKeyFor @NonNull @Initialized int ordinal) {
        if (expr instanceof RexInputRef) {
            int inputIndex = ((RexInputRef)expr).getIndex();
            String fieldName = ((RelDataTypeField)this.child.getRowType().getFieldList().get(inputIndex)).getName();
            if (!fieldName.startsWith("$") || fieldName.startsWith("$EXPR")) {
                return fieldName;
            }
        }
        return "$" + ordinal;
    }

    private void traceLevelExpressions(@UnknownKeyFor @NonNull @Initialized RexNode @UnknownKeyFor @NonNull @Initialized [] exprs, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] exprLevels, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] levelTypeOrdinals, @UnknownKeyFor @NonNull @Initialized int levelCount) {
        StringWriter traceMsg = new StringWriter();
        PrintWriter traceWriter = new PrintWriter(traceMsg);
        traceWriter.println("FarragoAutoCalcRule result expressions for: ");
        traceWriter.println(this.program.toString());
        for (int level = 0; level < levelCount; ++level) {
            traceWriter.println("Rel Level " + level + ", type " + this.relTypes[levelTypeOrdinals[level]]);
            for (int i = 0; i < exprs.length; ++i) {
                RexNode expr = exprs[i];
                assert (exprLevels[i] >= -1 && exprLevels[i] < levelCount) : "expression's level is out of range";
                if (exprLevels[i] != level) continue;
                traceWriter.println("\t" + i + ": " + expr);
            }
            traceWriter.println();
        }
        String msg = traceMsg.toString();
        RULE_LOGGER.trace(msg);
    }

    private static @UnknownKeyFor @NonNull @Initialized int count(@UnknownKeyFor @NonNull @Initialized boolean @UnknownKeyFor @NonNull @Initialized [] booleans) {
        int count = 0;
        for (boolean b : booleans) {
            if (!b) continue;
            ++count;
        }
        return count;
    }

    private static @UnknownKeyFor @NonNull @Initialized int firstSet(@UnknownKeyFor @NonNull @Initialized boolean @UnknownKeyFor @NonNull @Initialized [] booleans) {
        for (int i = 0; i < booleans.length; ++i) {
            if (!booleans[i]) continue;
            return i;
        }
        return -1;
    }

    private static @UnknownKeyFor @NonNull @Initialized int indexOf(@UnknownKeyFor @NonNull @Initialized int value, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] map) {
        for (int i = 0; i < map.length; ++i) {
            if (value != map[i]) continue;
            return i;
        }
        return -1;
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean canImplement(@UnknownKeyFor @NonNull @Initialized LogicalCalc rel, @UnknownKeyFor @NonNull @Initialized String relTypeName) {
        for (RelType relType : this.relTypes) {
            if (!relType.name.equals(relTypeName)) continue;
            return relType.canImplement(rel.getProgram());
        }
        throw new AssertionError((Object)("unknown type " + relTypeName));
    }

    protected @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer>> getCohorts() {
        return Collections.emptyList();
    }

    private static class HighestUsageFinder
    extends RexVisitorImpl<Void> {
        private final @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] maxUsingLevelOrdinals;
        private @UnknownKeyFor @NonNull @Initialized int currentLevel;

        HighestUsageFinder(@UnknownKeyFor @NonNull @Initialized RexNode @UnknownKeyFor @NonNull @Initialized [] exprs, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] exprLevels) {
            super(true);
            this.maxUsingLevelOrdinals = new int[exprs.length];
            Arrays.fill(this.maxUsingLevelOrdinals, -1);
            for (int i = 0; i < exprs.length; ++i) {
                if (exprs[i] instanceof RexLiteral) {
                    this.maxUsingLevelOrdinals[i] = -1;
                    continue;
                }
                this.currentLevel = exprLevels[i];
                Void void_ = (Void)exprs[i].accept((RexVisitor)this);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] getMaxUsingLevelOrdinals() {
            return this.maxUsingLevelOrdinals;
        }

        public @UnknownKeyFor @Nullable @Initialized Void visitLocalRef(@UnknownKeyFor @NonNull @Initialized RexLocalRef ref) {
            int index = ref.getIndex();
            this.maxUsingLevelOrdinals[index] = Math.max(this.maxUsingLevelOrdinals[index], this.currentLevel);
            return null;
        }
    }

    private static class MaxInputFinder
    extends RexVisitorImpl<Void> {
        @UnknownKeyFor @NonNull @Initialized int level;
        private final @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] exprLevels;

        MaxInputFinder(@UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] exprLevels) {
            super(true);
            this.exprLevels = exprLevels;
        }

        public @UnknownKeyFor @Nullable @Initialized Void visitLocalRef(@UnknownKeyFor @NonNull @Initialized RexLocalRef localRef) {
            int inputLevel = this.exprLevels[localRef.getIndex()];
            this.level = Math.max(this.level, inputLevel);
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized int maxInputFor(@UnknownKeyFor @NonNull @Initialized RexNode expr) {
            this.level = 0;
            expr.accept((RexVisitor)this);
            return this.level;
        }
    }

    private static class InputToCommonExprConverter
    extends RexShuttle {
        private final @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] exprInverseOrdinals;
        private final @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] exprLevels;
        private final @UnknownKeyFor @NonNull @Initialized int level;
        private final @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] inputExprOrdinals;
        private final @UnknownKeyFor @NonNull @Initialized RexNode @UnknownKeyFor @NonNull @Initialized [] allExprs;

        InputToCommonExprConverter(@UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] exprInverseOrdinals, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] exprLevels, @UnknownKeyFor @NonNull @Initialized int level, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] inputExprOrdinals, @UnknownKeyFor @NonNull @Initialized RexNode @UnknownKeyFor @NonNull @Initialized [] allExprs) {
            this.exprInverseOrdinals = exprInverseOrdinals;
            this.exprLevels = exprLevels;
            this.level = level;
            this.inputExprOrdinals = inputExprOrdinals;
            this.allExprs = allExprs;
        }

        public @UnknownKeyFor @NonNull @Initialized RexNode visitInputRef(@UnknownKeyFor @NonNull @Initialized RexInputRef input) {
            int index = this.exprInverseOrdinals[input.getIndex()];
            assert (index >= 0);
            return new RexLocalRef(index, input.getType());
        }

        public @UnknownKeyFor @NonNull @Initialized RexNode visitLocalRef(@UnknownKeyFor @NonNull @Initialized RexLocalRef local) {
            int localIndex = local.getIndex();
            int exprLevel = this.exprLevels[localIndex];
            if (exprLevel < this.level) {
                if (this.allExprs[localIndex] instanceof RexLiteral) {
                    return this.allExprs[localIndex];
                }
                int inputIndex = CalcRelSplitter.indexOf(localIndex, this.inputExprOrdinals);
                assert (inputIndex >= 0);
                return new RexLocalRef(inputIndex, local.getType());
            }
            int exprIndex = this.exprInverseOrdinals[localIndex];
            return new RexLocalRef(exprIndex, local.getType());
        }
    }

    private static class CannotImplement
    extends RuntimeException {
        static final @UnknownKeyFor @NonNull @Initialized CannotImplement INSTANCE = new CannotImplement();

        private CannotImplement() {
        }
    }

    private static class ImplementTester
    extends RexVisitorImpl<Void> {
        private final @UnknownKeyFor @NonNull @Initialized RelType relType;

        ImplementTester(@UnknownKeyFor @NonNull @Initialized RelType relType) {
            super(false);
            this.relType = relType;
        }

        public @UnknownKeyFor @Nullable @Initialized Void visitCall(@UnknownKeyFor @NonNull @Initialized RexCall call) {
            if (!this.relType.canImplement(call)) {
                throw CannotImplement.INSTANCE;
            }
            return null;
        }

        public @UnknownKeyFor @Nullable @Initialized Void visitDynamicParam(@UnknownKeyFor @NonNull @Initialized RexDynamicParam dynamicParam) {
            if (!this.relType.canImplement(dynamicParam)) {
                throw CannotImplement.INSTANCE;
            }
            return null;
        }

        public @UnknownKeyFor @Nullable @Initialized Void visitFieldAccess(@UnknownKeyFor @NonNull @Initialized RexFieldAccess fieldAccess) {
            if (!this.relType.canImplement(fieldAccess)) {
                throw CannotImplement.INSTANCE;
            }
            return null;
        }

        public @UnknownKeyFor @Nullable @Initialized Void visitLiteral(@UnknownKeyFor @NonNull @Initialized RexLiteral literal) {
            if (!this.relType.canImplement(literal)) {
                throw CannotImplement.INSTANCE;
            }
            return null;
        }
    }

    public static abstract class RelType {
        private final @UnknownKeyFor @NonNull @Initialized String name;

        protected RelType(@UnknownKeyFor @NonNull @Initialized String name) {
            this.name = name;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.name;
        }

        protected abstract @UnknownKeyFor @NonNull @Initialized boolean canImplement(@UnknownKeyFor @NonNull @Initialized RexFieldAccess var1);

        protected abstract @UnknownKeyFor @NonNull @Initialized boolean canImplement(@UnknownKeyFor @NonNull @Initialized RexDynamicParam var1);

        protected abstract @UnknownKeyFor @NonNull @Initialized boolean canImplement(@UnknownKeyFor @NonNull @Initialized RexLiteral var1);

        protected abstract @UnknownKeyFor @NonNull @Initialized boolean canImplement(@UnknownKeyFor @NonNull @Initialized RexCall var1);

        protected @UnknownKeyFor @NonNull @Initialized boolean supportsCondition() {
            return true;
        }

        protected @UnknownKeyFor @NonNull @Initialized RelNode makeRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelBuilder relBuilder, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized RexProgram program) {
            return LogicalCalc.create((RelNode)input, (RexProgram)program);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean canImplement(@UnknownKeyFor @NonNull @Initialized RexNode expr, @UnknownKeyFor @NonNull @Initialized boolean condition) {
            if (condition && !this.supportsCondition()) {
                return false;
            }
            try {
                expr.accept((RexVisitor)new ImplementTester(this));
                return true;
            }
            catch (CannotImplement e) {
                Util.swallow((Throwable)e, null);
                return false;
            }
        }

        public @UnknownKeyFor @NonNull @Initialized boolean canImplement(@UnknownKeyFor @NonNull @Initialized RexProgram program) {
            if (program.getCondition() != null && !this.canImplement((RexNode)program.getCondition(), true)) {
                return false;
            }
            for (RexNode expr : program.getExprList()) {
                if (this.canImplement(expr, false)) continue;
                return false;
            }
            return true;
        }
    }
}

