/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteTable;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.DefaultTableFilter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelWriter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamPushDownIOSourceRel
extends BeamIOSourceRel {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> usedFields;
    private final @UnknownKeyFor @NonNull @Initialized BeamSqlTableFilter tableFilters;

    public BeamPushDownIOSourceRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelOptTable table, @UnknownKeyFor @NonNull @Initialized BeamSqlTable beamTable, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> usedFields, @UnknownKeyFor @NonNull @Initialized BeamSqlTableFilter tableFilters, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> pipelineOptions, @UnknownKeyFor @NonNull @Initialized BeamCalciteTable calciteTable) {
        super(cluster, traitSet, table, beamTable, pipelineOptions, calciteTable);
        this.usedFields = usedFields;
        this.tableFilters = tableFilters;
    }

    public @UnknownKeyFor @NonNull @Initialized RelWriter explainTerms(@UnknownKeyFor @NonNull @Initialized RelWriter pw) {
        super.explainTerms(pw);
        if (!this.usedFields.isEmpty()) {
            pw.item("usedFields", (Object)this.usedFields.toString());
        }
        if (!(this.tableFilters instanceof DefaultTableFilter)) {
            pw.item(this.tableFilters.getClass().getSimpleName(), (Object)this.tableFilters.toString());
        }
        return pw;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new Transform();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        BeamCostModel parentCost = super.beamComputeSelfCost(planner, mq);
        Preconditions.checkArgument((parentCost.getCpu() >= 0.0 ? 1 : 0) != 0, (Object)"Cpu cost must be zero or positive.");
        double projectBenefit = this.getBeamSqlTable().getSchema().getFieldCount() - this.usedFields.size();
        double filterBenefit = this.tableFilters.numSupported();
        filterBenefit = (1.0 - 1.0 / (filterBenefit + 1.0)) * ((projectBenefit + 1.0) * 0.1);
        double totalBenefit = projectBenefit + filterBenefit;
        double normalizedBenefit = totalBenefit / (Math.max(totalBenefit, parentCost.getCpu()) + 1.0);
        BeamCostModel minus = BeamCostModel.FACTORY.makeTinyCost().multiplyBy(normalizedBenefit);
        return parentCost.minus(minus);
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> input) {
            Preconditions.checkArgument((input.size() == 0 ? 1 : 0) != 0, (String)"Should not have received input for %s: %s", (Object)BeamIOSourceRel.class.getSimpleName(), input);
            PBegin begin = input.getPipeline().begin();
            BeamSqlTable beamSqlTable = BeamPushDownIOSourceRel.this.getBeamSqlTable();
            if (BeamPushDownIOSourceRel.this.usedFields.isEmpty() && BeamPushDownIOSourceRel.this.tableFilters instanceof DefaultTableFilter) {
                return beamSqlTable.buildIOReader(begin);
            }
            Schema newBeamSchema = CalciteUtils.toSchema(BeamPushDownIOSourceRel.this.getRowType());
            return beamSqlTable.buildIOReader(begin, BeamPushDownIOSourceRel.this.tableFilters, BeamPushDownIOSourceRel.this.usedFields).setRowSchema(newBeamSchema);
        }
    }
}

