/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.TableNameExtractionUtils;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.meta.CustomTableResolver;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class TableResolutionUtils {
    TableResolutionUtils() {
    }

    static void setupCustomTableResolution(@UnknownKeyFor @NonNull @Initialized JdbcConnection connection, @UnknownKeyFor @NonNull @Initialized SqlNode parsed) {
        List<TableName> tableNames = TableNameExtractionUtils.extractTableNamesFromNode(parsed);
        String currentSchemaName = TableResolutionUtils.getCurrentSchemaName(connection);
        SchemaWithName defaultSchema = SchemaWithName.create(connection, currentSchemaName);
        if (defaultSchema.supportsCustomResolution()) {
            TableResolutionUtils.registerWithDefaultSchema(connection, tableNames, defaultSchema);
        }
        TableResolutionUtils.registerWithTopLevelSchemas(connection, tableNames);
    }

    private static @UnknownKeyFor @NonNull @Initialized String getCurrentSchemaName(@UnknownKeyFor @NonNull @Initialized JdbcConnection connection) {
        try {
            return connection.getSchema();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to get current schema name from JdbcConnection. Assuming table names in the query are fully-qualified from the root.", e);
        }
    }

    private static void registerWithDefaultSchema(@UnknownKeyFor @NonNull @Initialized JdbcConnection connection, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableName> tableNames, @UnknownKeyFor @NonNull @Initialized SchemaWithName defaultSchema) {
        Set topLevelSchemas = connection.getRootSchema().getSubSchemaNames();
        List simpleIdentifiers = tableNames.stream().filter(TableName::isSimple).collect(Collectors.toList());
        List withoutMatchingSchemas = tableNames.stream().filter(name -> name.isCompound() && !topLevelSchemas.contains(name.getPrefix())).collect(Collectors.toList());
        List explicitlyInDefaulSchema = tableNames.stream().filter(name -> name.isCompound() && name.getPrefix().equals(defaultSchema.name)).map(TableName::removePrefix).collect(Collectors.toList());
        ImmutableList shouldGoIntoDefaultSchema = ImmutableList.builder().addAll(simpleIdentifiers).addAll(withoutMatchingSchemas).addAll(explicitlyInDefaulSchema).build();
        defaultSchema.getCustomTableResolver().registerKnownTableNames((List<TableName>)shouldGoIntoDefaultSchema);
    }

    private static void registerWithTopLevelSchemas(@UnknownKeyFor @NonNull @Initialized JdbcConnection connection, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableName> tableNames) {
        Map<String, CustomTableResolver> topLevelResolvers = TableResolutionUtils.getCustomTopLevelResolvers(connection);
        topLevelResolvers.forEach((topLevelSchemaName, resolver) -> resolver.registerKnownTableNames(TableResolutionUtils.tablesForSchema(tableNames, topLevelSchemaName)));
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CustomTableResolver> getCustomTopLevelResolvers(@UnknownKeyFor @NonNull @Initialized JdbcConnection connection) {
        return connection.getRootSchema().getSubSchemaNames().stream().map(topLevelSchemaName -> SchemaWithName.create(connection, topLevelSchemaName)).filter(schema -> !schema.getName().equals(TableResolutionUtils.getCurrentSchemaName(connection))).filter(SchemaWithName::supportsCustomResolution).collect(Collectors.toMap(SchemaWithName::getName, SchemaWithName::getCustomTableResolver));
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableName> tablesForSchema(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableName> tableNames, @UnknownKeyFor @NonNull @Initialized String topLevelSchema) {
        return tableNames.stream().filter(TableName::isCompound).filter(t -> t.getPrefix().equals(topLevelSchema)).map(TableName::removePrefix).collect(Collectors.toList());
    }

    private static class SchemaWithName {
        @UnknownKeyFor @NonNull @Initialized String name;
        @UnknownKeyFor @NonNull @Initialized Schema schema;

        private SchemaWithName() {
        }

        static @UnknownKeyFor @NonNull @Initialized SchemaWithName create(@UnknownKeyFor @NonNull @Initialized JdbcConnection connection, @UnknownKeyFor @NonNull @Initialized String name) {
            SchemaWithName schemaWithName = new SchemaWithName();
            schemaWithName.name = name;
            schemaWithName.schema = CalciteSchema.from((SchemaPlus)connection.getRootSchema().getSubSchema((String)name)).schema;
            return schemaWithName;
        }

        @UnknownKeyFor @NonNull @Initialized boolean supportsCustomResolution() {
            return this.isBeamSchema() && this.tableProviderSupportsCustomResolution();
        }

        @UnknownKeyFor @NonNull @Initialized boolean isBeamSchema() {
            return this.schema instanceof BeamCalciteSchema;
        }

        @UnknownKeyFor @NonNull @Initialized boolean tableProviderSupportsCustomResolution() {
            return this.getTableProvider() instanceof CustomTableResolver;
        }

        @UnknownKeyFor @NonNull @Initialized TableProvider getTableProvider() {
            Preconditions.checkState((boolean)this.isBeamSchema());
            return ((BeamCalciteSchema)this.schema).getTableProvider();
        }

        @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.name;
        }

        @UnknownKeyFor @NonNull @Initialized CustomTableResolver getCustomTableResolver() {
            Preconditions.checkState((boolean)this.supportsCustomResolution());
            return (CustomTableResolver)this.getTableProvider();
        }
    }
}

