/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.example;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.example.model.Customer;
import org.apache.beam.sdk.extensions.sql.example.model.Order;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;

class BeamSqlPojoExample {
    BeamSqlPojoExample() {
    }

    public static void main(String[] args) {
        PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])args).create();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        PCollection<Customer> customers = BeamSqlPojoExample.loadCustomers(pipeline);
        PCollection<Order> orders = BeamSqlPojoExample.loadOrders(pipeline);
        PCollection customersFromWonderland = (PCollection)customers.apply((PTransform)SqlTransform.query("SELECT id, name  FROM PCOLLECTION  WHERE countryOfResidence = 'Wonderland'"));
        customersFromWonderland.apply(BeamSqlPojoExample.logRecords(": is from Wonderland"));
        PCollection totalInWonderland = (PCollection)customersFromWonderland.apply((PTransform)SqlTransform.query("SELECT COUNT(id) FROM PCOLLECTION"));
        totalInWonderland.apply(BeamSqlPojoExample.logRecords(": total customers in Wonderland"));
        PCollection ordersByGrault = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("customers"), customers).and(new TupleTag("orders"), orders).apply((PTransform)SqlTransform.query("SELECT customers.name, ('order id:' || CAST(orders.id AS VARCHAR)) FROM orders    JOIN customers ON orders.customerId = customers.id WHERE customers.name = 'Grault'"));
        ordersByGrault.apply(BeamSqlPojoExample.logRecords(": ordered by 'Grault'"));
        pipeline.run().waitUntilFinish();
    }

    private static MapElements<Row, Void> logRecords(final String suffix) {
        return MapElements.via((SimpleFunction)new SimpleFunction<Row, Void>(){

            public Void apply(Row input) {
                System.out.println(input.getValues() + suffix);
                return null;
            }
        });
    }

    private static PCollection<Customer> loadCustomers(Pipeline pipeline) {
        return (PCollection)pipeline.apply((PTransform)Create.of((Object)new Customer(1, "Foo", "Wonderland"), (Object[])new Customer[]{new Customer(2, "Bar", "Super Kingdom"), new Customer(3, "Baz", "Wonderland"), new Customer(4, "Grault", "Wonderland"), new Customer(5, "Qux", "Super Kingdom")}));
    }

    private static PCollection<Order> loadOrders(Pipeline pipeline) {
        return (PCollection)pipeline.apply((PTransform)Create.of((Object)new Order(1, 5), (Object[])new Order[]{new Order(2, 2), new Order(3, 1), new Order(4, 3), new Order(5, 1), new Order(6, 5), new Order(7, 4), new Order(8, 4), new Order(9, 1)}));
    }
}

