/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta;

import com.alibaba.fastjson.JSONObject;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.schemas.Schema;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_Table
extends Table {
    private final String type;
    private final String name;
    private final Schema schema;
    private final @Nullable String comment;
    private final @Nullable String location;
    private final JSONObject properties;

    private AutoValue_Table(String type, String name, Schema schema, @Nullable String comment, @Nullable String location, JSONObject properties) {
        this.type = type;
        this.name = name;
        this.schema = schema;
        this.comment = comment;
        this.location = location;
        this.properties = properties;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public @Nullable String getComment() {
        return this.comment;
    }

    @Override
    public @Nullable String getLocation() {
        return this.location;
    }

    @Override
    public JSONObject getProperties() {
        return this.properties;
    }

    public String toString() {
        return "Table{type=" + this.type + ", name=" + this.name + ", schema=" + this.schema + ", comment=" + this.comment + ", location=" + this.location + ", properties=" + this.properties + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Table) {
            Table that = (Table)o;
            return this.type.equals(that.getType()) && this.name.equals(that.getName()) && this.schema.equals((Object)that.getSchema()) && (this.comment == null ? that.getComment() == null : this.comment.equals(that.getComment())) && (this.location == null ? that.getLocation() == null : this.location.equals(that.getLocation())) && this.properties.equals((Object)that.getProperties());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.schema.hashCode();
        h$ *= 1000003;
        h$ ^= this.comment == null ? 0 : this.comment.hashCode();
        h$ *= 1000003;
        h$ ^= this.location == null ? 0 : this.location.hashCode();
        h$ *= 1000003;
        return h$ ^= this.properties.hashCode();
    }

    @Override
    public Table.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Table.Builder {
        private String type;
        private String name;
        private Schema schema;
        private @Nullable String comment;
        private @Nullable String location;
        private JSONObject properties;

        Builder() {
        }

        private Builder(Table source) {
            this.type = source.getType();
            this.name = source.getName();
            this.schema = source.getSchema();
            this.comment = source.getComment();
            this.location = source.getLocation();
            this.properties = source.getProperties();
        }

        @Override
        public Table.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public Table.Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public Table.Builder schema(Schema schema) {
            if (schema == null) {
                throw new NullPointerException("Null schema");
            }
            this.schema = schema;
            return this;
        }

        @Override
        public Table.Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Table.Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public Table.Builder properties(JSONObject properties) {
            if (properties == null) {
                throw new NullPointerException("Null properties");
            }
            this.properties = properties;
            return this;
        }

        @Override
        public Table build() {
            if (this.type == null || this.name == null || this.schema == null || this.properties == null) {
                StringBuilder missing = new StringBuilder();
                if (this.type == null) {
                    missing.append(" type");
                }
                if (this.name == null) {
                    missing.append(" name");
                }
                if (this.schema == null) {
                    missing.append(" schema");
                }
                if (this.properties == null) {
                    missing.append(" properties");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Table(this.type, this.name, this.schema, this.comment, this.location, this.properties);
        }
    }
}

