/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.test;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.Lists;

@Experimental
public class TestTableUtils {
    public static Schema buildBeamSqlSchema(Object ... args) {
        return (Schema)Stream.iterate(0, i -> i + 2).limit(args.length / 2).map(i -> TestTableUtils.toRecordField(args, i)).collect(Schema.toSchema());
    }

    public static Schema buildBeamSqlNullableSchema(Object ... args) {
        return (Schema)Stream.iterate(0, i -> i + 3).limit(args.length / 3).map(i -> TestTableUtils.toNullableRecordField(args, i)).collect(Schema.toSchema());
    }

    public static Schema.Field toRecordField(Object[] args, int i) {
        return Schema.Field.of((String)((String)args[i + 1]), (Schema.FieldType)((Schema.FieldType)args[i]));
    }

    public static Schema.Field toNullableRecordField(Object[] args, int i) {
        if (((Boolean)args[i + 2]).booleanValue()) {
            return Schema.Field.nullable((String)((String)args[i + 1]), (Schema.FieldType)((Schema.FieldType)args[i]));
        }
        return Schema.Field.of((String)((String)args[i + 1]), (Schema.FieldType)((Schema.FieldType)args[i]));
    }

    public static List<Row> buildRows(Schema type, List<?> rowsValues) {
        return Lists.partition(rowsValues, (int)type.getFieldCount()).stream().map(values -> (Row)values.stream().collect(Row.toRow((Schema)type))).collect(Collectors.toList());
    }
}

