/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.AutoValue_TableName;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

@AutoValue
public abstract class TableName {
    public abstract List<String> getPath();

    public abstract String getTableName();

    public static TableName create(List<String> fullPath) {
        Preconditions.checkNotNull(fullPath, (Object)"Full table path cannot be null");
        Preconditions.checkArgument((fullPath.size() > 0 ? 1 : 0) != 0, (Object)"Full table path has to have at least one element");
        return TableName.create(fullPath.subList(0, fullPath.size() - 1), fullPath.get(fullPath.size() - 1));
    }

    public static TableName create(List<String> path, String tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"Table name cannot be null");
        return new AutoValue_TableName(path == null ? Collections.emptyList() : path, tableName);
    }

    public boolean isCompound() {
        return this.getPath().size() > 0;
    }

    public boolean isSimple() {
        return this.getPath().size() == 0;
    }

    public String getPrefix() {
        Preconditions.checkState((boolean)this.isCompound());
        return this.getPath().get(0);
    }

    public TableName removePrefix() {
        List<String> pathPostfix = this.getPath().stream().skip(1L).collect(Collectors.toList());
        return TableName.create(pathPostfix, this.getTableName());
    }
}

