/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaTable;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.kafka.clients.producer.ProducerRecord;

public class PayloadSerializerKafkaTable
extends BeamKafkaTable {
    private final PayloadSerializer serializer;

    PayloadSerializerKafkaTable(Schema requiredSchema, String bootstrapServers, List<String> topics, PayloadSerializer serializer) {
        super(requiredSchema, bootstrapServers, topics);
        this.serializer = serializer;
    }

    @Override
    protected PTransform<PCollection<KafkaRecord<byte[], byte[]>>, PCollection<Row>> getPTransformForInput() {
        return new PTransform<PCollection<KafkaRecord<byte[], byte[]>>, PCollection<Row>>("deserialize-kafka-rows"){

            public PCollection<Row> expand(PCollection<KafkaRecord<byte[], byte[]>> input) {
                return ((PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Row.class)).via((SerializableFunction & Serializable)record -> PayloadSerializerKafkaTable.this.serializer.deserialize((byte[])record.getKV().getValue())))).setRowSchema(PayloadSerializerKafkaTable.this.getSchema());
            }
        };
    }

    @Override
    protected PTransform<PCollection<Row>, PCollection<ProducerRecord<byte[], byte[]>>> getPTransformForOutput() {
        final String topic = (String)Iterables.getOnlyElement(this.getTopics());
        return new PTransform<PCollection<Row>, PCollection<ProducerRecord<byte[], byte[]>>>("serialize-kafka-rows"){

            public PCollection<ProducerRecord<byte[], byte[]>> expand(PCollection<Row> input) {
                return (PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<ProducerRecord<byte[], byte[]>>(){}).via((SerializableFunction & Serializable)row -> new ProducerRecord(topic, (Object)new byte[0], (Object)PayloadSerializerKafkaTable.this.serializer.serialize(row))));
            }
        };
    }
}

