/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import com.alibaba.fastjson.JSONObject;
import com.google.auto.service.AutoService;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.base.MoreObjects;

@AutoService(value={TableProvider.class})
public class BigQueryTableProvider
extends InMemoryMetaTableProvider {
    @Override
    public String getTableType() {
        return "bigquery";
    }

    @Override
    public BeamSqlTable buildBeamSqlTable(Table table) {
        return new BigQueryTable(table, BigQueryTableProvider.getConversionOptions(table.getProperties()));
    }

    protected static BigQueryUtils.ConversionOptions getConversionOptions(JSONObject properties) {
        return BigQueryUtils.ConversionOptions.builder().setTruncateTimestamps((Boolean)MoreObjects.firstNonNull((Object)properties.getBoolean("truncateTimestamps"), (Object)false) != false ? BigQueryUtils.ConversionOptions.TruncateTimestamps.TRUNCATE : BigQueryUtils.ConversionOptions.TruncateTimestamps.REJECT).build();
    }
}

