/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamBuiltinAggregations;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableMap;

public class BeamBuiltinAnalyticFunctions {
    public static final Map<String, Function<Schema.FieldType, Combine.CombineFn<?, ?, ?>>> BUILTIN_ANALYTIC_FACTORIES = ImmutableMap.builder().putAll(BeamBuiltinAggregations.BUILTIN_AGGREGATOR_FACTORIES).put((Object)"FIRST_VALUE", typeName -> BeamBuiltinAnalyticFunctions.navigationFirstValue()).put((Object)"LAST_VALUE", typeName -> BeamBuiltinAnalyticFunctions.navigationLastValue()).put((Object)"ROW_NUMBER", typeName -> BeamBuiltinAnalyticFunctions.numberingRowNumber()).put((Object)"DENSE_RANK", typeName -> BeamBuiltinAnalyticFunctions.numberingDenseRank()).put((Object)"RANK", typeName -> BeamBuiltinAnalyticFunctions.numberingRank()).put((Object)"PERCENT_RANK", typeName -> BeamBuiltinAnalyticFunctions.numberingPercentRank()).build();

    public static Combine.CombineFn<?, ?, ?> create(String functionName, Schema.FieldType fieldType) {
        Function<Schema.FieldType, Combine.CombineFn<?, ?, ?>> aggregatorFactory = BUILTIN_ANALYTIC_FACTORIES.get(functionName);
        if (aggregatorFactory != null) {
            return aggregatorFactory.apply(fieldType);
        }
        throw new UnsupportedOperationException(String.format("Analytics Function [%s] is not supported", functionName));
    }

    public static <T> Combine.CombineFn<T, ?, T> navigationFirstValue() {
        return new FirstValueCombineFn();
    }

    public static <T> Combine.CombineFn<T, ?, T> navigationLastValue() {
        return new LastValueCombineFn();
    }

    public static <T> Combine.CombineFn<T, ?, T> numberingRowNumber() {
        return new RowNumberCombineFn();
    }

    public static <T> Combine.CombineFn<T, ?, T> numberingDenseRank() {
        return new DenseRankCombineFn();
    }

    public static <T> Combine.CombineFn<T, ?, T> numberingRank() {
        return new RankCombineFn();
    }

    public static <T> Combine.CombineFn<T, ?, T> numberingPercentRank() {
        return new PercentRankCombineFn();
    }

    private static class PercentRankCombineFn<T>
    extends PositionAwareCombineFn<BigDecimal, KV<Optional<Long>, KV<BigDecimal, Long>>, Double> {
        RankCombineFn internalRank = new RankCombineFn();

        PercentRankCombineFn() {
        }

        @Override
        public KV<Optional<Long>, KV<BigDecimal, Long>> addInput(KV<Optional<Long>, KV<BigDecimal, Long>> accumulator, BigDecimal input, Long cursorPosition, Long cursorPartition, Long countPartition) {
            KV<BigDecimal, Long> ac1 = this.internalRank.addInput((KV<BigDecimal, Long>)((KV)accumulator.getValue()), input, cursorPosition, cursorPartition, countPartition);
            Optional<Long> ac2 = Optional.of(countPartition);
            return KV.of(ac2, ac1);
        }

        public KV<Optional<Long>, KV<BigDecimal, Long>> createAccumulator() {
            return KV.of(Optional.empty(), this.internalRank.createAccumulator());
        }

        public Double extractOutput(KV<Optional<Long>, KV<BigDecimal, Long>> accumulator) {
            Long nr = ((Optional)accumulator.getKey()).orElse(null);
            Long rk = this.internalRank.extractOutput((KV<BigDecimal, Long>)((KV)accumulator.getValue()));
            Double r = 0.0;
            if (nr != null && rk != null && nr > 1L) {
                r = (rk.doubleValue() - 1.0) / (nr.doubleValue() - 1.0);
            }
            return r;
        }
    }

    private static class RankCombineFn<T>
    extends PositionAwareCombineFn<BigDecimal, KV<BigDecimal, Long>, Long> {
        private RankCombineFn() {
        }

        @Override
        public KV<BigDecimal, Long> addInput(KV<BigDecimal, Long> accumulator, BigDecimal input, Long cursorPosition, Long cursorPartition, Long countPartition) {
            KV r = null;
            r = accumulator == null ? KV.of((Object)input, (Object)0L) : (((BigDecimal)accumulator.getKey()).compareTo(input) == 0 ? KV.of((Object)input, (Object)((Long)accumulator.getValue())) : KV.of((Object)input, (Object)cursorPosition));
            return r;
        }

        public KV<BigDecimal, Long> createAccumulator() {
            return null;
        }

        public Long extractOutput(KV<BigDecimal, Long> accumulator) {
            return accumulator != null ? Long.valueOf((Long)accumulator.getValue() + 1L) : null;
        }
    }

    private static class DenseRankCombineFn<T>
    extends PositionAwareCombineFn<BigDecimal, KV<BigDecimal, Long>, Long> {
        private DenseRankCombineFn() {
        }

        @Override
        public KV<BigDecimal, Long> addInput(KV<BigDecimal, Long> accumulator, BigDecimal input, Long cursorPosition, Long cursorPartition, Long countPartition) {
            KV r = null;
            r = accumulator == null ? KV.of((Object)input, (Object)0L) : (((BigDecimal)accumulator.getKey()).compareTo(input) == 0 ? KV.of((Object)input, (Object)((Long)accumulator.getValue())) : KV.of((Object)input, (Object)((Long)accumulator.getValue() + 1L)));
            return r;
        }

        public KV<BigDecimal, Long> createAccumulator() {
            return null;
        }

        public Long extractOutput(KV<BigDecimal, Long> accumulator) {
            return accumulator != null ? Long.valueOf((Long)accumulator.getValue() + 1L) : null;
        }
    }

    private static class RowNumberCombineFn<T>
    extends PositionAwareCombineFn<BigDecimal, Optional<Long>, Long> {
        private RowNumberCombineFn() {
        }

        @Override
        public Optional<Long> addInput(Optional<Long> accumulator, BigDecimal input, Long cursorPosition, Long cursorPartition, Long countPartition) {
            return Optional.of(cursorPartition);
        }

        public Optional<Long> createAccumulator() {
            return Optional.empty();
        }

        public Long extractOutput(Optional<Long> accumulator) {
            return accumulator.isPresent() ? Long.valueOf(accumulator.get() + 1L) : null;
        }
    }

    public static abstract class PositionAwareCombineFn<InputT, AccumT, OutputT>
    extends Combine.CombineFn<InputT, AccumT, OutputT> {
        public abstract AccumT addInput(AccumT var1, InputT var2, Long var3, Long var4, Long var5);

        public AccumT addInput(AccumT mutableAccumulator, InputT input) {
            throw new UnsupportedOperationException();
        }

        public AccumT mergeAccumulators(Iterable<AccumT> accumulators) {
            throw new UnsupportedOperationException();
        }
    }

    private static class LastValueCombineFn<T>
    extends Combine.CombineFn<T, Optional<T>, T> {
        private LastValueCombineFn() {
        }

        public Optional<T> createAccumulator() {
            return Optional.empty();
        }

        public Optional<T> addInput(Optional<T> accumulator, T input) {
            Optional<T> r = Optional.of(input);
            return r;
        }

        public Optional<T> mergeAccumulators(Iterable<Optional<T>> accumulators) {
            throw new UnsupportedOperationException();
        }

        public T extractOutput(Optional<T> accumulator) {
            return accumulator.isPresent() ? (T)accumulator.get() : null;
        }
    }

    private static class FirstValueCombineFn<T>
    extends Combine.CombineFn<T, Optional<T>, T> {
        private FirstValueCombineFn() {
        }

        public Optional<T> createAccumulator() {
            return Optional.empty();
        }

        public Optional<T> addInput(Optional<T> accumulator, T input) {
            Optional<T> r = accumulator;
            if (!accumulator.isPresent()) {
                r = Optional.of(input);
            }
            return r;
        }

        public Optional<T> mergeAccumulators(Iterable<Optional<T>> accumulators) {
            throw new UnsupportedOperationException();
        }

        public T extractOutput(Optional<T> accumulator) {
            return accumulator.isPresent() ? (T)accumulator.get() : null;
        }
    }
}

