/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlDrop;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Static;

abstract class SqlDropObject
extends SqlDrop
implements BeamSqlParser.ExecutableStatement {
    protected final SqlIdentifier name;

    SqlDropObject(SqlOperator operator, SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        super(operator, pos, ifExists);
        this.name = name;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.name);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getOperator().getName());
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void execute(CalcitePrepare.Context context) {
        List path = context.getDefaultSchemaPath();
        CalciteSchema schema = context.getRootSchema();
        for (String p : path) {
            if ((schema = schema.getSubSchema(p, true)) == null) {
                throw new AssertionError((Object)String.format("Got null sub-schema for path '%s' in %s", p, path));
            }
        }
        switch (this.getKind()) {
            case DROP_TABLE: {
                boolean existed;
                if (schema.schema instanceof BeamCalciteSchema) {
                    BeamCalciteSchema beamSchema = (BeamCalciteSchema)schema.schema;
                    beamSchema.getTableProvider().dropTable(this.name.getSimple());
                    existed = true;
                } else {
                    existed = schema.removeTable(this.name.getSimple());
                }
                if (existed || this.ifExists) break;
                throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.tableNotFound(this.name.getSimple()));
            }
            default: {
                throw new AssertionError(this.getKind());
            }
        }
    }
}

