/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlAsOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlJoin;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlSelect;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlSetOperator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TableNameExtractionUtils {
    public static List<TableName> extractTableNamesFromNode(@Nullable SqlNode node) {
        if (node instanceof SqlSelect) {
            return TableNameExtractionUtils.extractTableFromSelect((SqlSelect)node);
        }
        if (node instanceof SqlIdentifier) {
            return TableNameExtractionUtils.extractFromIdentifier((SqlIdentifier)node);
        }
        if (node instanceof SqlJoin) {
            return TableNameExtractionUtils.extractFromJoin((SqlJoin)node);
        }
        if (node instanceof SqlCall) {
            return TableNameExtractionUtils.extractFromCall((SqlCall)node);
        }
        return Collections.emptyList();
    }

    private static List<TableName> extractTableFromSelect(SqlSelect node) {
        return TableNameExtractionUtils.extractTableNamesFromNode(node.getFrom());
    }

    private static List<TableName> extractFromCall(SqlCall node) {
        if (node.getOperator() instanceof SqlAsOperator) {
            return TableNameExtractionUtils.extractTableNamesFromNode((SqlNode)node.getOperandList().get(0));
        }
        if (node.getOperator() instanceof SqlSetOperator) {
            return node.getOperandList().stream().map(TableNameExtractionUtils::extractTableNamesFromNode).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<TableName> extractFromJoin(SqlJoin join) {
        return ImmutableList.builder().addAll(TableNameExtractionUtils.extractTableNamesFromNode(join.getLeft())).addAll(TableNameExtractionUtils.extractTableNamesFromNode(join.getRight())).build();
    }

    private static List<TableName> extractFromIdentifier(SqlIdentifier identifier) {
        return ImmutableList.of((Object)TableName.create((List<String>)identifier.names));
    }
}

