/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import java.util.Properties;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.Context;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCostFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptSchema;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitDef;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.prepare.PlannerImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexExecutor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.server.CalciteServerStatement;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.parser.SqlParser;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.Planner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.Program;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.Programs;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.RuleSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Util;

public class Frameworks {
    private Frameworks() {
    }

    public static Planner getPlanner(FrameworkConfig config) {
        return new PlannerImpl(config);
    }

    public static <R> R withPlanner(final PlannerAction<R> action, final FrameworkConfig config) {
        return Frameworks.withPrepare(new PrepareAction<R>(config){

            @Override
            public R apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, CalciteServerStatement statement) {
                CalciteSchema schema = CalciteSchema.from(Util.first(config.getDefaultSchema(), rootSchema));
                return action.apply(cluster, relOptSchema, schema.root().plus());
            }
        });
    }

    public static <R> R withPlanner(PlannerAction<R> action) {
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(Frameworks.createRootSchema(true)).build();
        return Frameworks.withPlanner(action, config);
    }

    public static <R> R withPrepare(PrepareAction<R> action) {
        try {
            Properties info = new Properties();
            if (((PrepareAction)action).config.getTypeSystem() != RelDataTypeSystem.DEFAULT) {
                info.setProperty(CalciteConnectionProperty.TYPE_SYSTEM.camelName(), ((PrepareAction)action).config.getTypeSystem().getClass().getName());
            }
            Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
            CalciteServerStatement statement = connection.createStatement().unwrap(CalciteServerStatement.class);
            return new CalcitePrepareImpl().perform(statement, action);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SchemaPlus createRootSchema(boolean addMetadataSchema) {
        return CalciteSchema.createRootSchema(addMetadataSchema).plus();
    }

    public static ConfigBuilder newConfigBuilder() {
        return new ConfigBuilder();
    }

    static class StdFrameworkConfig
    implements FrameworkConfig {
        private final Context context;
        private final SqlRexConvertletTable convertletTable;
        private final SqlOperatorTable operatorTable;
        private final ImmutableList<Program> programs;
        private final ImmutableList<RelTraitDef> traitDefs;
        private final SqlParser.Config parserConfig;
        private final SqlToRelConverter.Config sqlToRelConverterConfig;
        private final SchemaPlus defaultSchema;
        private final RelOptCostFactory costFactory;
        private final RelDataTypeSystem typeSystem;
        private final RexExecutor executor;

        StdFrameworkConfig(Context context, SqlRexConvertletTable convertletTable, SqlOperatorTable operatorTable, ImmutableList<Program> programs, ImmutableList<RelTraitDef> traitDefs, SqlParser.Config parserConfig, SqlToRelConverter.Config sqlToRelConverterConfig, SchemaPlus defaultSchema, RelOptCostFactory costFactory, RelDataTypeSystem typeSystem, RexExecutor executor) {
            this.context = context;
            this.convertletTable = convertletTable;
            this.operatorTable = operatorTable;
            this.programs = programs;
            this.traitDefs = traitDefs;
            this.parserConfig = parserConfig;
            this.sqlToRelConverterConfig = sqlToRelConverterConfig;
            this.defaultSchema = defaultSchema;
            this.costFactory = costFactory;
            this.typeSystem = typeSystem;
            this.executor = executor;
        }

        @Override
        public SqlParser.Config getParserConfig() {
            return this.parserConfig;
        }

        @Override
        public SqlToRelConverter.Config getSqlToRelConverterConfig() {
            return this.sqlToRelConverterConfig;
        }

        @Override
        public SchemaPlus getDefaultSchema() {
            return this.defaultSchema;
        }

        @Override
        public RexExecutor getExecutor() {
            return this.executor;
        }

        @Override
        public ImmutableList<Program> getPrograms() {
            return this.programs;
        }

        @Override
        public RelOptCostFactory getCostFactory() {
            return this.costFactory;
        }

        @Override
        public ImmutableList<RelTraitDef> getTraitDefs() {
            return this.traitDefs;
        }

        @Override
        public SqlRexConvertletTable getConvertletTable() {
            return this.convertletTable;
        }

        @Override
        public Context getContext() {
            return this.context;
        }

        @Override
        public SqlOperatorTable getOperatorTable() {
            return this.operatorTable;
        }

        @Override
        public RelDataTypeSystem getTypeSystem() {
            return this.typeSystem;
        }
    }

    public static class ConfigBuilder {
        private SqlRexConvertletTable convertletTable = StandardConvertletTable.INSTANCE;
        private SqlOperatorTable operatorTable = SqlStdOperatorTable.instance();
        private ImmutableList<Program> programs = ImmutableList.of();
        private Context context;
        private ImmutableList<RelTraitDef> traitDefs;
        private SqlParser.Config parserConfig = SqlParser.Config.DEFAULT;
        private SqlToRelConverter.Config sqlToRelConverterConfig = SqlToRelConverter.Config.DEFAULT;
        private SchemaPlus defaultSchema;
        private RexExecutor executor;
        private RelOptCostFactory costFactory;
        private RelDataTypeSystem typeSystem = RelDataTypeSystem.DEFAULT;

        private ConfigBuilder() {
        }

        public FrameworkConfig build() {
            return new StdFrameworkConfig(this.context, this.convertletTable, this.operatorTable, this.programs, this.traitDefs, this.parserConfig, this.sqlToRelConverterConfig, this.defaultSchema, this.costFactory, this.typeSystem, this.executor);
        }

        public ConfigBuilder context(Context c) {
            this.context = Preconditions.checkNotNull(c);
            return this;
        }

        public ConfigBuilder executor(RexExecutor executor) {
            Preconditions.checkNotNull(executor);
            this.executor = executor;
            return this;
        }

        public ConfigBuilder convertletTable(SqlRexConvertletTable convertletTable) {
            this.convertletTable = Preconditions.checkNotNull(convertletTable);
            return this;
        }

        public ConfigBuilder operatorTable(SqlOperatorTable operatorTable) {
            this.operatorTable = Preconditions.checkNotNull(operatorTable);
            return this;
        }

        public ConfigBuilder traitDefs(List<RelTraitDef> traitDefs) {
            this.traitDefs = traitDefs == null ? null : ImmutableList.copyOf(traitDefs);
            return this;
        }

        public ConfigBuilder traitDefs(RelTraitDef ... traitDefs) {
            this.traitDefs = ImmutableList.copyOf(traitDefs);
            return this;
        }

        public ConfigBuilder parserConfig(SqlParser.Config parserConfig) {
            this.parserConfig = Preconditions.checkNotNull(parserConfig);
            return this;
        }

        public ConfigBuilder sqlToRelConverterConfig(SqlToRelConverter.Config sqlToRelConverterConfig) {
            this.sqlToRelConverterConfig = Preconditions.checkNotNull(sqlToRelConverterConfig);
            return this;
        }

        public ConfigBuilder defaultSchema(SchemaPlus defaultSchema) {
            this.defaultSchema = defaultSchema;
            return this;
        }

        public ConfigBuilder costFactory(RelOptCostFactory costFactory) {
            this.costFactory = costFactory;
            return this;
        }

        public ConfigBuilder ruleSets(RuleSet ... ruleSets) {
            return this.programs(Programs.listOf(ruleSets));
        }

        public ConfigBuilder ruleSets(List<RuleSet> ruleSets) {
            return this.programs(Programs.listOf(Preconditions.checkNotNull(ruleSets)));
        }

        public ConfigBuilder programs(List<Program> programs) {
            this.programs = ImmutableList.copyOf(programs);
            return this;
        }

        public ConfigBuilder programs(Program ... programs) {
            this.programs = ImmutableList.copyOf(programs);
            return this;
        }

        public ConfigBuilder typeSystem(RelDataTypeSystem typeSystem) {
            this.typeSystem = Preconditions.checkNotNull(typeSystem);
            return this;
        }
    }

    public static abstract class PrepareAction<R> {
        private final FrameworkConfig config;

        public PrepareAction() {
            this.config = Frameworks.newConfigBuilder().defaultSchema(Frameworks.createRootSchema(true)).build();
        }

        public PrepareAction(FrameworkConfig config) {
            this.config = config;
        }

        public FrameworkConfig getConfig() {
            return this.config;
        }

        public abstract R apply(RelOptCluster var1, RelOptSchema var2, SchemaPlus var3, CalciteServerStatement var4);
    }

    public static interface PlannerAction<R> {
        public R apply(RelOptCluster var1, RelOptSchema var2, SchemaPlus var3);
    }
}

