/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate;

import java.util.List;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlModality;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Pair;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Util;

abstract class AbstractNamespace
implements SqlValidatorNamespace {
    protected final SqlValidatorImpl validator;
    private SqlValidatorImpl.Status status = SqlValidatorImpl.Status.UNVALIDATED;
    protected RelDataType rowType;
    protected RelDataType type;
    protected final SqlNode enclosingNode;

    AbstractNamespace(SqlValidatorImpl validator, SqlNode enclosingNode) {
        this.validator = validator;
        this.enclosingNode = enclosingNode;
    }

    @Override
    public SqlValidator getValidator() {
        return this.validator;
    }

    @Override
    public final void validate(RelDataType targetRowType) {
        switch (this.status) {
            case UNVALIDATED: {
                try {
                    this.status = SqlValidatorImpl.Status.IN_PROGRESS;
                    Preconditions.checkArgument(this.rowType == null, "Namespace.rowType must be null before validate has been called");
                    RelDataType type = this.validateImpl(targetRowType);
                    Preconditions.checkArgument(type != null, "validateImpl() returned null");
                    this.setType(type);
                    break;
                }
                finally {
                    this.status = SqlValidatorImpl.Status.VALID;
                }
            }
            case IN_PROGRESS: {
                throw new AssertionError((Object)"Cycle detected during type-checking");
            }
            case VALID: {
                break;
            }
            default: {
                throw Util.unexpected(this.status);
            }
        }
    }

    protected abstract RelDataType validateImpl(RelDataType var1);

    @Override
    public RelDataType getRowType() {
        if (this.rowType == null) {
            this.validator.validateNamespace(this, this.validator.unknownType);
            Preconditions.checkArgument(this.rowType != null, "validate must set rowType");
        }
        return this.rowType;
    }

    @Override
    public RelDataType getRowTypeSansSystemColumns() {
        return this.getRowType();
    }

    @Override
    public RelDataType getType() {
        Util.discard(this.getRowType());
        return this.type;
    }

    @Override
    public void setType(RelDataType type) {
        this.type = type;
        this.rowType = this.convertToStruct(type);
    }

    @Override
    public SqlNode getEnclosingNode() {
        return this.enclosingNode;
    }

    @Override
    public SqlValidatorTable getTable() {
        return null;
    }

    @Override
    public SqlValidatorNamespace lookupChild(String name) {
        return this.validator.lookupFieldNamespace(this.getRowType(), name);
    }

    @Override
    public boolean fieldExists(String name) {
        RelDataType rowType = this.getRowType();
        return this.validator.catalogReader.nameMatcher().field(rowType, name) != null;
    }

    @Override
    public List<Pair<SqlNode, SqlMonotonicity>> getMonotonicExprs() {
        return ImmutableList.of();
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public void makeNullable() {
    }

    public String translate(String name) {
        return name;
    }

    @Override
    public SqlValidatorNamespace resolve() {
        return this;
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        return true;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return clazz.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }

    protected RelDataType convertToStruct(RelDataType type) {
        RelDataType collectionType;
        RelDataType componentType = type.getComponentType();
        if (componentType == null || componentType.isStruct()) {
            return type;
        }
        RelDataTypeFactory typeFactory = this.validator.getTypeFactory();
        RelDataType structType = this.toStruct(componentType, this.getNode());
        switch (type.getSqlTypeName()) {
            case ARRAY: {
                collectionType = typeFactory.createArrayType(structType, -1L);
                break;
            }
            case MULTISET: {
                collectionType = typeFactory.createMultisetType(structType, -1L);
                break;
            }
            default: {
                throw new AssertionError(type);
            }
        }
        return typeFactory.createTypeWithNullability(collectionType, type.isNullable());
    }

    protected RelDataType toStruct(RelDataType type, SqlNode unnest) {
        if (type.isStruct()) {
            return type;
        }
        return this.validator.getTypeFactory().builder().add(this.validator.deriveAlias(unnest, 0), type).build();
    }
}

