/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.dialect;

import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlDialect;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.OracleSqlOperatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlFloorFunction;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class OracleSqlDialect
extends SqlDialect {
    public static final SqlDialect DEFAULT = new OracleSqlDialect(EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.ORACLE).withIdentifierQuoteString("\""));

    public OracleSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    protected boolean allowsAs() {
        return false;
    }

    @Override
    public boolean supportsAliasedValues() {
        return false;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
            SqlUtil.unparseFunctionSyntax(OracleSqlOperatorTable.SUBSTR, writer, call);
        } else {
            switch (call.getKind()) {
                case FLOOR: {
                    if (call.operandCount() != 2) {
                        super.unparseCall(writer, call, leftPrec, rightPrec);
                        return;
                    }
                    SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
                    TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
                    SqlCall call2 = SqlFloorFunction.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                    SqlFloorFunction.unparseDatetimeFunction(writer, call2, "TRUNC", true);
                    break;
                }
                default: {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                }
            }
        }
    }
}

