/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.runtime;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorBoundary;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorIntersects;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SpatialReference;
import java.math.BigDecimal;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.function.Deterministic;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.function.SemiStrict;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.function.Strict;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Util;

@Deterministic
@Strict
public class GeoFunctions {
    private static final int NO_SRID = 0;
    private static final SpatialReference SPATIAL_REFERENCE = SpatialReference.create((int)4326);

    private GeoFunctions() {
    }

    private static UnsupportedOperationException todo() {
        return new UnsupportedOperationException();
    }

    protected static Geom bind(Geometry geometry, int srid) {
        if (geometry == null) {
            return null;
        }
        if (srid == 0) {
            return new SimpleGeom(geometry);
        }
        return GeoFunctions.bind(geometry, SpatialReference.create((int)srid));
    }

    private static MapGeom bind(Geometry geometry, SpatialReference sr) {
        return new MapGeom(new MapGeometry(geometry, sr));
    }

    public static String ST_AsText(Geom g) {
        return GeoFunctions.ST_AsWKT(g);
    }

    public static String ST_AsWKT(Geom g) {
        return GeometryEngine.geometryToWkt((Geometry)g.g(), (int)0);
    }

    public static Geom ST_GeomFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geom ST_GeomFromText(String s, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt((String)s, (int)0, (Geometry.Type)Geometry.Type.Unknown);
        return GeoFunctions.bind(g, srid);
    }

    public static Geom ST_LineFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geom ST_LineFromText(String wkt, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt((String)wkt, (int)0, (Geometry.Type)Geometry.Type.Line);
        return GeoFunctions.bind(g, srid);
    }

    public static Geom ST_MPointFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geom ST_MPointFromText(String wkt, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt((String)wkt, (int)0, (Geometry.Type)Geometry.Type.MultiPoint);
        return GeoFunctions.bind(g, srid);
    }

    public static Geom ST_PointFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geom ST_PointFromText(String wkt, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt((String)wkt, (int)0, (Geometry.Type)Geometry.Type.Point);
        return GeoFunctions.bind(g, srid);
    }

    public static Geom ST_PolyFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geom ST_PolyFromText(String wkt, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt((String)wkt, (int)0, (Geometry.Type)Geometry.Type.Polygon);
        return GeoFunctions.bind(g, srid);
    }

    public static Geom ST_MLineFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geom ST_MLineFromText(String wkt, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt((String)wkt, (int)0, (Geometry.Type)Geometry.Type.Unknown);
        return GeoFunctions.bind(g, srid);
    }

    public static Geom ST_MPolyFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geom ST_MPolyFromText(String wkt, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt((String)wkt, (int)0, (Geometry.Type)Geometry.Type.Unknown);
        return GeoFunctions.bind(g, srid);
    }

    public static Geom ST_MakeLine(Geom geom1, Geom geom2) {
        return GeoFunctions.makeLine(geom1, geom2);
    }

    public static Geom ST_MakeLine(Geom geom1, Geom geom2, Geom geom3) {
        return GeoFunctions.makeLine(geom1, geom2, geom3);
    }

    public static Geom ST_MakeLine(Geom geom1, Geom geom2, Geom geom3, Geom geom4) {
        return GeoFunctions.makeLine(geom1, geom2, geom3, geom4);
    }

    public static Geom ST_MakeLine(Geom geom1, Geom geom2, Geom geom3, Geom geom4, Geom geom5) {
        return GeoFunctions.makeLine(geom1, geom2, geom3, geom4, geom5);
    }

    public static Geom ST_MakeLine(Geom geom1, Geom geom2, Geom geom3, Geom geom4, Geom geom5, Geom geom6) {
        return GeoFunctions.makeLine(geom1, geom2, geom3, geom4, geom5, geom6);
    }

    private static Geom makeLine(Geom ... geoms) {
        Polyline g = new Polyline();
        Point p = null;
        for (Geom geom : geoms) {
            if (!(geom.g() instanceof Point)) continue;
            Point prev = p;
            p = (Point)geom.g();
            if (prev == null) continue;
            Line line = new Line();
            line.setStart(prev);
            line.setEnd(p);
            g.addSegment((Segment)line, false);
        }
        return new SimpleGeom((Geometry)g);
    }

    public static Geom ST_MakePoint(BigDecimal x, BigDecimal y) {
        return GeoFunctions.ST_Point(x, y);
    }

    public static Geom ST_MakePoint(BigDecimal x, BigDecimal y, BigDecimal z) {
        return GeoFunctions.ST_Point(x, y, z);
    }

    public static Geom ST_Point(BigDecimal x, BigDecimal y) {
        return GeoFunctions.point(x.doubleValue(), y.doubleValue());
    }

    public static Geom ST_Point(BigDecimal x, BigDecimal y, BigDecimal z) {
        Point g = new Point(x.doubleValue(), y.doubleValue(), z.doubleValue());
        return new SimpleGeom((Geometry)g);
    }

    private static Geom point(double x, double y) {
        Point g = new Point(x, y);
        return new SimpleGeom((Geometry)g);
    }

    public static boolean ST_Is3D(Geom geom) {
        return geom.g().hasZ();
    }

    public static Double ST_X(Geom geom) {
        return geom.g() instanceof Point ? Double.valueOf(((Point)geom.g()).getX()) : null;
    }

    public static Double ST_Y(Geom geom) {
        return geom.g() instanceof Point ? Double.valueOf(((Point)geom.g()).getY()) : null;
    }

    public static Double ST_Z(Geom geom) {
        return geom.g().getDescription().hasZ() && geom.g() instanceof Point ? Double.valueOf(((Point)geom.g()).getZ()) : null;
    }

    public static Geom ST_Boundary(Geom geom) {
        OperatorBoundary op = OperatorBoundary.local();
        Geometry result = op.execute(geom.g(), null);
        return geom.wrap(result);
    }

    public static double ST_Distance(Geom geom1, Geom geom2) {
        return GeometryEngine.distance((Geometry)geom1.g(), (Geometry)geom2.g(), (SpatialReference)geom1.sr());
    }

    public static String ST_GeometryType(Geom geom) {
        return GeoFunctions.type(geom.g()).name();
    }

    public static int ST_GeometryTypeCode(Geom geom) {
        return GeoFunctions.type((Geometry)geom.g()).code;
    }

    private static Type type(Geometry g) {
        switch (g.getType()) {
            case Point: {
                return Type.POINT;
            }
            case Polyline: {
                return Type.LINESTRING;
            }
            case Polygon: {
                return Type.POLYGON;
            }
            case MultiPoint: {
                return Type.MULTIPOINT;
            }
            case Envelope: {
                return Type.POLYGON;
            }
            case Line: {
                return Type.LINESTRING;
            }
            case Unknown: {
                return Type.Geometry;
            }
        }
        throw new AssertionError(g);
    }

    public static Geom ST_Envelope(Geom geom) {
        Envelope env = GeoFunctions.envelope(geom.g());
        return geom.wrap((Geometry)env);
    }

    private static Envelope envelope(Geometry g) {
        Envelope env = new Envelope();
        g.queryEnvelope(env);
        return env;
    }

    public static boolean ST_Contains(Geom geom1, Geom geom2) {
        return GeometryEngine.contains((Geometry)geom1.g(), (Geometry)geom2.g(), (SpatialReference)geom1.sr());
    }

    public static boolean ST_ContainsProperly(Geom geom1, Geom geom2) {
        return GeometryEngine.contains((Geometry)geom1.g(), (Geometry)geom2.g(), (SpatialReference)geom1.sr()) && !GeometryEngine.crosses((Geometry)geom1.g(), (Geometry)geom2.g(), (SpatialReference)geom1.sr());
    }

    private static boolean ST_Covers(Geom geom1, Geom geom2) {
        throw GeoFunctions.todo();
    }

    public static boolean ST_Crosses(Geom geom1, Geom geom2) {
        return GeometryEngine.crosses((Geometry)geom1.g(), (Geometry)geom2.g(), (SpatialReference)geom1.sr());
    }

    public static boolean ST_Disjoint(Geom geom1, Geom geom2) {
        return GeometryEngine.disjoint((Geometry)geom1.g(), (Geometry)geom2.g(), (SpatialReference)geom1.sr());
    }

    public static boolean ST_EnvelopesIntersect(Geom geom1, Geom geom2) {
        Envelope e1 = GeoFunctions.envelope(geom1.g());
        Envelope e2 = GeoFunctions.envelope(geom2.g());
        return GeoFunctions.intersects((Geometry)e1, (Geometry)e2, geom1.sr());
    }

    public static boolean ST_Equals(Geom geom1, Geom geom2) {
        return GeometryEngine.equals((Geometry)geom1.g(), (Geometry)geom2.g(), (SpatialReference)geom1.sr());
    }

    public static boolean ST_Intersects(Geom geom1, Geom geom2) {
        Geometry g1 = geom1.g();
        Geometry g2 = geom2.g();
        SpatialReference sr = geom1.sr();
        return GeoFunctions.intersects(g1, g2, sr);
    }

    private static boolean intersects(Geometry g1, Geometry g2, SpatialReference sr) {
        OperatorIntersects op = (OperatorIntersects)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Intersects);
        return op.execute(g1, g2, sr, null);
    }

    public static boolean ST_OrderingEquals(Geom geom1, Geom geom2) {
        return GeometryEngine.equals((Geometry)geom1.g(), (Geometry)geom2.g(), (SpatialReference)geom1.sr());
    }

    public static boolean ST_Overlaps(Geom geom1, Geom geom2) {
        return GeometryEngine.overlaps((Geometry)geom1.g(), (Geometry)geom2.g(), (SpatialReference)geom1.sr());
    }

    public static boolean ST_Touches(Geom geom1, Geom geom2) {
        return GeometryEngine.touches((Geometry)geom1.g(), (Geometry)geom2.g(), (SpatialReference)geom1.sr());
    }

    public static boolean ST_Within(Geom geom1, Geom geom2) {
        return GeometryEngine.within((Geometry)geom1.g(), (Geometry)geom2.g(), (SpatialReference)geom1.sr());
    }

    public static boolean ST_DWithin(Geom geom1, Geom geom2, double distance) {
        double distance1 = GeometryEngine.distance((Geometry)geom1.g(), (Geometry)geom2.g(), (SpatialReference)geom1.sr());
        return distance1 <= distance;
    }

    public static Geom ST_Buffer(Geom geom, double distance) {
        Polygon g = GeometryEngine.buffer((Geometry)geom.g(), (SpatialReference)geom.sr(), (double)distance);
        return geom.wrap((Geometry)g);
    }

    public static Geom ST_Buffer(Geom geom, double distance, int quadSegs) {
        throw GeoFunctions.todo();
    }

    public static Geom ST_Buffer(Geom geom, double bufferSize, String style) {
        int equals;
        int quadSegCount = 8;
        CapStyle endCapStyle = CapStyle.ROUND;
        JoinStyle joinStyle = JoinStyle.ROUND;
        float mitreLimit = 5.0f;
        int i = 0;
        block13: while ((equals = style.indexOf(61, i)) >= 0) {
            int space = style.indexOf(32, equals);
            if (space < 0) {
                space = style.length();
            }
            String name = style.substring(i, equals);
            String value = style.substring(equals + 1, space);
            switch (name) {
                case "quad_segs": {
                    quadSegCount = Integer.valueOf(value);
                    break;
                }
                case "endcap": {
                    endCapStyle = CapStyle.of(value);
                    break;
                }
                case "join": {
                    joinStyle = JoinStyle.of(value);
                    break;
                }
                case "mitre_limit": 
                case "miter_limit": {
                    mitreLimit = Float.parseFloat(value);
                    break;
                }
            }
            for (i = space; i < style.length(); ++i) {
                if (style.charAt(i) != ' ') continue block13;
            }
        }
        return GeoFunctions.buffer(geom, bufferSize, quadSegCount, endCapStyle, joinStyle, mitreLimit);
    }

    private static Geom buffer(Geom geom, double bufferSize, int quadSegCount, CapStyle endCapStyle, JoinStyle joinStyle, float mitreLimit) {
        Util.discard((Object)((Object)endCapStyle) + ":" + (Object)((Object)joinStyle) + ":" + mitreLimit + ":" + quadSegCount);
        throw GeoFunctions.todo();
    }

    public static Geom ST_Union(Geom geom1, Geom geom2) {
        SpatialReference sr = geom1.sr();
        Geometry g = GeometryEngine.union((Geometry[])new Geometry[]{geom1.g(), geom2.g()}, (SpatialReference)sr);
        return GeoFunctions.bind(g, sr);
    }

    @SemiStrict
    public static Geom ST_Union(Geom geomCollection) {
        SpatialReference sr = geomCollection.sr();
        Geometry g = GeometryEngine.union((Geometry[])new Geometry[]{geomCollection.g()}, (SpatialReference)sr);
        return GeoFunctions.bind(g, sr);
    }

    public static Geom ST_Transform(Geom geom, int srid) {
        return geom.transform(srid);
    }

    public static Geom ST_SetSRID(Geom geom, int srid) {
        return geom.transform(srid);
    }

    static enum Type {
        Geometry(0),
        POINT(1),
        LINESTRING(2),
        POLYGON(3),
        MULTIPOINT(4),
        MULTILINESTRING(5),
        MULTIPOLYGON(6),
        GEOMCOLLECTION(7),
        CURVE(13),
        SURFACE(14),
        POLYHEDRALSURFACE(15);

        final int code;

        private Type(int code) {
            this.code = code;
        }
    }

    static class MapGeom
    implements Geom {
        final MapGeometry mg;

        MapGeom(MapGeometry mg) {
            this.mg = Preconditions.checkNotNull(mg);
        }

        public String toString() {
            return this.mg.toString();
        }

        @Override
        public Geometry g() {
            return this.mg.getGeometry();
        }

        @Override
        public SpatialReference sr() {
            return this.mg.getSpatialReference();
        }

        @Override
        public Geom transform(int srid) {
            if (srid == 0) {
                return new SimpleGeom(this.mg.getGeometry());
            }
            if (srid == this.mg.getSpatialReference().getID()) {
                return this;
            }
            return GeoFunctions.bind(this.mg.getGeometry(), srid);
        }

        @Override
        public Geom wrap(Geometry g) {
            return GeoFunctions.bind(g, this.mg.getSpatialReference());
        }
    }

    static class SimpleGeom
    implements Geom {
        final Geometry g;

        SimpleGeom(Geometry g) {
            this.g = Preconditions.checkNotNull(g);
        }

        public String toString() {
            return this.g.toString();
        }

        @Override
        public Geometry g() {
            return this.g;
        }

        @Override
        public SpatialReference sr() {
            return SPATIAL_REFERENCE;
        }

        @Override
        public Geom transform(int srid) {
            if (srid == SPATIAL_REFERENCE.getID()) {
                return this;
            }
            return GeoFunctions.bind(this.g, srid);
        }

        @Override
        public Geom wrap(Geometry g) {
            return new SimpleGeom(g);
        }
    }

    public static interface Geom {
        public Geometry g();

        public SpatialReference sr();

        public Geom transform(int var1);

        public Geom wrap(Geometry var1);
    }

    static enum JoinStyle {
        ROUND,
        MITRE,
        BEVEL;


        static JoinStyle of(String value) {
            switch (value) {
                case "round": {
                    return ROUND;
                }
                case "mitre": 
                case "miter": {
                    return MITRE;
                }
                case "bevel": {
                    return BEVEL;
                }
            }
            throw new IllegalArgumentException("unknown join value: " + value);
        }
    }

    static enum CapStyle {
        ROUND,
        FLAT,
        SQUARE;


        static CapStyle of(String value) {
            switch (value) {
                case "round": {
                    return ROUND;
                }
                case "flat": 
                case "butt": {
                    return FLAT;
                }
                case "square": {
                    return SQUARE;
                }
            }
            throw new IllegalArgumentException("unknown endcap value: " + value);
        }
    }
}

