/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableMultimap;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.Multimap;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.jdbc.JdbcTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.jdbc.JdbcUtils;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.AvaticaUtils;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.SqlType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.Function;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.Schema;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.SchemaFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.SchemaVersion;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.Schemas;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.Table;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlDialect;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlDialectFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlDialectFactoryImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Util;

public class JdbcSchema
implements Schema {
    final DataSource dataSource;
    final String catalog;
    final String schema;
    public final SqlDialect dialect;
    final JdbcConvention convention;
    private ImmutableMap<String, JdbcTable> tableMap;
    private final boolean snapshot;

    public JdbcSchema(DataSource dataSource, SqlDialect dialect, JdbcConvention convention, String catalog, String schema) {
        this(dataSource, dialect, convention, catalog, schema, null);
    }

    private JdbcSchema(DataSource dataSource, SqlDialect dialect, JdbcConvention convention, String catalog, String schema, ImmutableMap<String, JdbcTable> tableMap) {
        this.dataSource = Preconditions.checkNotNull(dataSource);
        this.dialect = Preconditions.checkNotNull(dialect);
        this.convention = convention;
        this.catalog = catalog;
        this.schema = schema;
        this.tableMap = tableMap;
        this.snapshot = tableMap != null;
    }

    public static JdbcSchema create(SchemaPlus parentSchema, String name, DataSource dataSource, String catalog, String schema) {
        return JdbcSchema.create(parentSchema, name, dataSource, new SqlDialectFactoryImpl(), catalog, schema);
    }

    public static JdbcSchema create(SchemaPlus parentSchema, String name, DataSource dataSource, SqlDialectFactory dialectFactory, String catalog, String schema) {
        Expression expression = Schemas.subSchemaExpression(parentSchema, name, JdbcSchema.class);
        SqlDialect dialect = JdbcSchema.createDialect(dialectFactory, dataSource);
        JdbcConvention convention = JdbcConvention.of(dialect, expression, name);
        return new JdbcSchema(dataSource, dialect, convention, catalog, schema);
    }

    public static JdbcSchema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        DataSource dataSource;
        try {
            String dataSourceName = (String)operand.get("dataSource");
            if (dataSourceName != null) {
                dataSource = AvaticaUtils.instantiatePlugin(DataSource.class, dataSourceName);
            } else {
                String jdbcUrl = (String)operand.get("jdbcUrl");
                String jdbcDriver = (String)operand.get("jdbcDriver");
                String jdbcUser = (String)operand.get("jdbcUser");
                String jdbcPassword = (String)operand.get("jdbcPassword");
                dataSource = JdbcSchema.dataSource(jdbcUrl, jdbcDriver, jdbcUser, jdbcPassword);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading dataSource", e);
        }
        String jdbcCatalog = (String)operand.get("jdbcCatalog");
        String jdbcSchema = (String)operand.get("jdbcSchema");
        String sqlDialectFactory = (String)operand.get("sqlDialectFactory");
        if (sqlDialectFactory == null || sqlDialectFactory.isEmpty()) {
            return JdbcSchema.create(parentSchema, name, dataSource, jdbcCatalog, jdbcSchema);
        }
        SqlDialectFactory factory = AvaticaUtils.instantiatePlugin(SqlDialectFactory.class, sqlDialectFactory);
        return JdbcSchema.create(parentSchema, name, dataSource, factory, jdbcCatalog, jdbcSchema);
    }

    @Deprecated
    public static SqlDialect createDialect(DataSource dataSource) {
        return JdbcSchema.createDialect(new SqlDialectFactoryImpl(), dataSource);
    }

    public static SqlDialect createDialect(SqlDialectFactory dialectFactory, DataSource dataSource) {
        return JdbcUtils.DialectPool.INSTANCE.get(dialectFactory, dataSource);
    }

    public static DataSource dataSource(String url, String driverClassName, String username, String password) {
        if (url.startsWith("jdbc:hsqldb:")) {
            System.setProperty("hsqldb.reconfig_logging", "false");
        }
        return JdbcUtils.DataSourcePool.INSTANCE.get(url, driverClassName, username, password);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Schema snapshot(SchemaVersion version) {
        return new JdbcSchema(this.dataSource, this.dialect, this.convention, this.catalog, this.schema, this.tableMap);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return Schemas.subSchemaExpression(parentSchema, name, JdbcSchema.class);
    }

    protected Multimap<String, Function> getFunctions() {
        return ImmutableMultimap.of();
    }

    @Override
    public final Collection<Function> getFunctions(String name) {
        return this.getFunctions().get(name);
    }

    @Override
    public final Set<String> getFunctionNames() {
        return this.getFunctions().keySet();
    }

    private ImmutableMap<String, JdbcTable> computeTables() {
        ImmutableMap<String, JdbcTable> immutableMap;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            resultSet = metaData.getTables(this.catalog, this.schema, null, null);
            ImmutableMap.Builder<String, JdbcTable> builder = ImmutableMap.builder();
            while (resultSet.next()) {
                String tableName = resultSet.getString(3);
                String catalogName = resultSet.getString(1);
                String schemaName = resultSet.getString(2);
                String tableTypeName = resultSet.getString(4);
                String tableTypeName2 = tableTypeName == null ? null : tableTypeName.toUpperCase(Locale.ROOT).replace(' ', '_');
                Schema.TableType tableType = Util.enumVal(Schema.TableType.OTHER, tableTypeName2);
                if (tableType == Schema.TableType.OTHER && tableTypeName2 != null) {
                    System.out.println("Unknown table type: " + tableTypeName2);
                }
                JdbcTable table = new JdbcTable(this, catalogName, schemaName, tableName, tableType);
                builder.put(tableName, table);
            }
            immutableMap = builder.build();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException("Exception while reading tables", e);
            }
            catch (Throwable throwable) {
                JdbcSchema.close(connection, null, resultSet);
                throw throwable;
            }
        }
        JdbcSchema.close(connection, null, resultSet);
        return immutableMap;
    }

    @Override
    public Table getTable(String name) {
        return this.getTableMap(false).get(name);
    }

    private synchronized ImmutableMap<String, JdbcTable> getTableMap(boolean force) {
        if (force || this.tableMap == null) {
            this.tableMap = this.computeTables();
        }
        return this.tableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelProtoDataType getRelDataType(String catalogName, String schemaName, String tableName) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            RelProtoDataType relProtoDataType = this.getRelDataType(metaData, catalogName, schemaName, tableName);
            return relProtoDataType;
        }
        finally {
            JdbcSchema.close(connection, null, null);
        }
    }

    RelProtoDataType getRelDataType(DatabaseMetaData metaData, String catalogName, String schemaName, String tableName) throws SQLException {
        ResultSet resultSet = metaData.getColumns(catalogName, schemaName, tableName, null);
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        while (resultSet.next()) {
            int scale;
            int precision;
            String columnName = resultSet.getString(4);
            int dataType = resultSet.getInt(5);
            String typeString = resultSet.getString(6);
            switch (SqlType.valueOf(dataType)) {
                case TIMESTAMP: 
                case TIME: {
                    precision = resultSet.getInt(9);
                    scale = 0;
                    break;
                }
                default: {
                    precision = resultSet.getInt(7);
                    scale = resultSet.getInt(9);
                }
            }
            RelDataType sqlType = this.sqlType(typeFactory, dataType, precision, scale, typeString);
            boolean nullable = resultSet.getInt(11) != 0;
            ((RelDataTypeFactory.Builder)fieldInfo).add(columnName, sqlType).nullable(nullable);
        }
        resultSet.close();
        return RelDataTypeImpl.proto(fieldInfo.build());
    }

    private RelDataType sqlType(RelDataTypeFactory typeFactory, int dataType, int precision, int scale, String typeString) {
        SqlTypeName sqlTypeName = Util.first(SqlTypeName.getNameForJdbcType(dataType), SqlTypeName.ANY);
        switch (sqlTypeName) {
            case ARRAY: {
                RelDataType component = null;
                if (typeString != null && typeString.endsWith(" ARRAY")) {
                    String remaining = typeString.substring(0, typeString.length() - " ARRAY".length());
                    component = this.parseTypeString(typeFactory, remaining);
                }
                if (component == null) {
                    component = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
                }
                return typeFactory.createArrayType(component, -1L);
            }
        }
        if (precision >= 0 && scale >= 0 && sqlTypeName.allowsPrecScale(true, true)) {
            return typeFactory.createSqlType(sqlTypeName, precision, scale);
        }
        if (precision >= 0 && sqlTypeName.allowsPrecNoScale()) {
            return typeFactory.createSqlType(sqlTypeName, precision);
        }
        assert (sqlTypeName.allowsNoPrecNoScale());
        return typeFactory.createSqlType(sqlTypeName);
    }

    private RelDataType parseTypeString(RelDataTypeFactory typeFactory, String typeString) {
        int close;
        int precision = -1;
        int scale = -1;
        int open = typeString.indexOf("(");
        if (open >= 0 && (close = typeString.indexOf(")", open)) >= 0) {
            String rest = typeString.substring(open + 1, close);
            typeString = typeString.substring(0, open);
            int comma = rest.indexOf(",");
            if (comma >= 0) {
                precision = Integer.parseInt(rest.substring(0, comma));
                scale = Integer.parseInt(rest.substring(comma));
            } else {
                precision = Integer.parseInt(rest);
            }
        }
        try {
            SqlTypeName typeName = SqlTypeName.valueOf(typeString);
            return typeName.allowsPrecScale(true, true) ? typeFactory.createSqlType(typeName, precision, scale) : (typeName.allowsPrecScale(true, false) ? typeFactory.createSqlType(typeName, precision) : typeFactory.createSqlType(typeName));
        }
        catch (IllegalArgumentException e) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
        }
    }

    @Override
    public Set<String> getTableNames() {
        return this.getTableMap(!this.snapshot).keySet();
    }

    @Override
    public Schema getSubSchema(String name) {
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return ImmutableSet.of();
    }

    private static void close(Connection connection, Statement statement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static class Factory
    implements SchemaFactory {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            return JdbcSchema.create(parentSchema, name, operand);
        }
    }
}

