/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.elasticsearch.ElasticsearchRules;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.elasticsearch.MapProjectionFieldVisitor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelCollation;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelFieldCollation;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Project;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Sort;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Util;

public class ElasticsearchSort
extends Sort
implements ElasticsearchRel {
    public ElasticsearchSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, collation, offset, fetch);
        assert (this.getConvention() == ElasticsearchRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    @Override
    public Sort copy(RelTraitSet traitSet, RelNode relNode, RelCollation relCollation, RexNode offset, RexNode fetch) {
        return new ElasticsearchSort(this.getCluster(), traitSet, relNode, this.collation, offset, fetch);
    }

    @Override
    public void implement(ElasticsearchRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        if (!this.collation.getFieldCollations().isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>();
            if (this.input instanceof Project) {
                List<RexNode> projects = ((Project)this.input).getProjects();
                for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
                    RexNode project = projects.get(fieldCollation.getFieldIndex());
                    String name = project.accept(MapProjectionFieldVisitor.INSTANCE);
                    keys.add(ElasticsearchRules.quote(name) + ": " + this.direction(fieldCollation));
                }
            } else {
                List<RelDataTypeField> fields = this.getRowType().getFieldList();
                for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
                    String name = fields.get(fieldCollation.getFieldIndex()).getName();
                    keys.add(ElasticsearchRules.quote(name) + ": " + this.direction(fieldCollation));
                }
            }
            implementor.add("\"sort\": [ " + Util.toString(keys, "{", "}, {", "}") + "]");
        }
        if (this.offset != null) {
            implementor.add("\"from\": " + ((RexLiteral)this.offset).getValue());
        }
        if (this.fetch != null) {
            implementor.add("\"size\": " + ((RexLiteral)this.fetch).getValue());
        }
    }

    private String direction(RelFieldCollation fieldCollation) {
        switch (fieldCollation.getDirection()) {
            case DESCENDING: 
            case STRICTLY_DESCENDING: {
                return "\"desc\"";
            }
        }
        return "\"asc\"";
    }
}

