/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaTable;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowType;
import org.apache.commons.csv.CSVFormat;

public class BeamKafkaCSVTable
extends BeamKafkaTable {
    private CSVFormat csvFormat;

    public BeamKafkaCSVTable(RowType beamRowType, String bootstrapServers, List<String> topics) {
        this(beamRowType, bootstrapServers, topics, CSVFormat.DEFAULT);
    }

    public BeamKafkaCSVTable(RowType beamRowType, String bootstrapServers, List<String> topics, CSVFormat format) {
        super(beamRowType, bootstrapServers, topics);
        this.csvFormat = format;
    }

    @Override
    public PTransform<PCollection<KV<byte[], byte[]>>, PCollection<Row>> getPTransformForInput() {
        return new CsvRecorderDecoder(this.rowType, this.csvFormat);
    }

    @Override
    public PTransform<PCollection<Row>, PCollection<KV<byte[], byte[]>>> getPTransformForOutput() {
        return new CsvRecorderEncoder(this.rowType, this.csvFormat);
    }

    public static class CsvRecorderEncoder
    extends PTransform<PCollection<Row>, PCollection<KV<byte[], byte[]>>> {
        private RowType rowType;
        private CSVFormat format;

        public CsvRecorderEncoder(RowType rowType, CSVFormat format) {
            this.rowType = rowType;
            this.format = format;
        }

        public PCollection<KV<byte[], byte[]>> expand(PCollection<Row> input) {
            return (PCollection)input.apply("encodeRecord", (PTransform)ParDo.of((DoFn)new DoFn<Row, KV<byte[], byte[]>>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    Row in = (Row)c.element();
                    c.output((Object)KV.of((Object)new byte[0], (Object)BeamTableUtils.beamRow2CsvLine(in, format).getBytes()));
                }
            }));
        }
    }

    public static class CsvRecorderDecoder
    extends PTransform<PCollection<KV<byte[], byte[]>>, PCollection<Row>> {
        private RowType rowType;
        private CSVFormat format;

        public CsvRecorderDecoder(RowType rowType, CSVFormat format) {
            this.rowType = rowType;
            this.format = format;
        }

        public PCollection<Row> expand(PCollection<KV<byte[], byte[]>> input) {
            return (PCollection)input.apply("decodeRecord", (PTransform)ParDo.of((DoFn)new DoFn<KV<byte[], byte[]>, Row>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    String rowInString = new String((byte[])((KV)c.element()).getValue());
                    c.output((Object)BeamTableUtils.csvLine2BeamRow(format, rowInString, rowType));
                }
            }));
        }
    }
}

