/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta;

import com.alibaba.fastjson.JSONObject;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.sql.meta.Column;
import org.apache.beam.sdk.extensions.sql.meta.Table;

final class AutoValue_Table
extends Table {
    private final String type;
    private final String name;
    private final List<Column> columns;
    private final String comment;
    private final URI location;
    private final JSONObject properties;

    private AutoValue_Table(String type, String name, List<Column> columns, @Nullable String comment, @Nullable URI location, @Nullable JSONObject properties) {
        this.type = type;
        this.name = name;
        this.columns = columns;
        this.comment = comment;
        this.location = location;
        this.properties = properties;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Override
    @Nullable
    public URI getLocation() {
        return this.location;
    }

    @Override
    @Nullable
    public JSONObject getProperties() {
        return this.properties;
    }

    public String toString() {
        return "Table{type=" + this.type + ", name=" + this.name + ", columns=" + this.columns + ", comment=" + this.comment + ", location=" + this.location + ", properties=" + this.properties + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Table) {
            Table that = (Table)o;
            return this.type.equals(that.getType()) && this.name.equals(that.getName()) && this.columns.equals(that.getColumns()) && (this.comment == null ? that.getComment() == null : this.comment.equals(that.getComment())) && (this.location == null ? that.getLocation() == null : this.location.equals(that.getLocation())) && (this.properties == null ? that.getProperties() == null : this.properties.equals((Object)that.getProperties()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.type.hashCode();
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.columns.hashCode();
        h *= 1000003;
        h ^= this.comment == null ? 0 : this.comment.hashCode();
        h *= 1000003;
        h ^= this.location == null ? 0 : this.location.hashCode();
        h *= 1000003;
        return h ^= this.properties == null ? 0 : this.properties.hashCode();
    }

    static final class Builder
    extends Table.Builder {
        private String type;
        private String name;
        private List<Column> columns;
        private String comment;
        private URI location;
        private JSONObject properties;

        Builder() {
        }

        @Override
        public Table.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public Table.Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public Table.Builder columns(List<Column> columns) {
            if (columns == null) {
                throw new NullPointerException("Null columns");
            }
            this.columns = columns;
            return this;
        }

        @Override
        public Table.Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Table.Builder location(@Nullable URI location) {
            this.location = location;
            return this;
        }

        @Override
        public Table.Builder properties(@Nullable JSONObject properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public Table build() {
            String missing = "";
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.columns == null) {
                missing = missing + " columns";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Table(this.type, this.name, this.columns, this.comment, this.location, this.properties);
        }
    }
}

