/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.SqlTypeCoder;
import org.apache.beam.sdk.extensions.sql.SqlTypeCoders;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableMap;

public class BigDecimalConverter {
    private static final Map<SqlTypeCoder, SerializableFunction<BigDecimal, ? extends Number>> CONVERTER_MAP = ImmutableMap.builder().put(SqlTypeCoders.INTEGER, BigDecimal::intValue).put(SqlTypeCoders.SMALLINT, (SerializableFunction & Serializable)((SerializableFunction & Serializable)Number::shortValue)).put(SqlTypeCoders.TINYINT, (SerializableFunction & Serializable)((SerializableFunction & Serializable)Number::byteValue)).put(SqlTypeCoders.BIGINT, (SerializableFunction & Serializable)((SerializableFunction & Serializable)BigDecimal::longValue)).put(SqlTypeCoders.FLOAT, (SerializableFunction & Serializable)((SerializableFunction & Serializable)BigDecimal::floatValue)).put(SqlTypeCoders.DOUBLE, (SerializableFunction & Serializable)((SerializableFunction & Serializable)BigDecimal::doubleValue)).put(SqlTypeCoders.DECIMAL, (SerializableFunction & Serializable)(SerializableFunction & Serializable)v -> v).build();

    public static SerializableFunction<BigDecimal, ? extends Number> forSqlType(SqlTypeCoder sqlTypeCoder) {
        if (!CONVERTER_MAP.containsKey((Object)sqlTypeCoder)) {
            throw new UnsupportedOperationException("Conversion from " + (Object)((Object)sqlTypeCoder) + " to BigDecimal is not supported");
        }
        return CONVERTER_MAP.get((Object)sqlTypeCoder);
    }
}

