/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform.agg;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.VarianceAccumulator;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.SerializableFunction;

@Internal
public class VarianceFn<T extends Number>
extends Combine.CombineFn<T, VarianceAccumulator, T> {
    static final MathContext MATH_CTX = new MathContext(10, RoundingMode.HALF_UP);
    private static final boolean SAMPLE = true;
    private static final boolean POP = false;
    private boolean isSample;
    private SerializableFunction<BigDecimal, T> decimalConverter;

    public static <V extends Number> VarianceFn newPopulation(SerializableFunction<BigDecimal, V> decimalConverter) {
        return new VarianceFn<V>(false, decimalConverter);
    }

    public static <V extends Number> VarianceFn newSample(SerializableFunction<BigDecimal, V> decimalConverter) {
        return new VarianceFn<V>(true, decimalConverter);
    }

    private VarianceFn(boolean isSample, SerializableFunction<BigDecimal, T> decimalConverter) {
        this.isSample = isSample;
        this.decimalConverter = decimalConverter;
    }

    public VarianceAccumulator createAccumulator() {
        return VarianceAccumulator.ofZeroElements();
    }

    public VarianceAccumulator addInput(VarianceAccumulator currentVariance, T rawInput) {
        if (rawInput == null) {
            return currentVariance;
        }
        return currentVariance.combineWith(VarianceAccumulator.ofSingleElement(this.toBigDecimal(rawInput)));
    }

    public VarianceAccumulator mergeAccumulators(Iterable<VarianceAccumulator> variances) {
        return StreamSupport.stream(variances.spliterator(), false).reduce(VarianceAccumulator.ofZeroElements(), VarianceAccumulator::combineWith);
    }

    public Coder<VarianceAccumulator> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) {
        return SerializableCoder.of(VarianceAccumulator.class);
    }

    public T extractOutput(VarianceAccumulator accumulator) {
        return (T)((Number)this.decimalConverter.apply((Object)this.getVariance(accumulator)));
    }

    private BigDecimal getVariance(VarianceAccumulator variance) {
        BigDecimal adjustedCount = this.isSample ? variance.count().subtract(BigDecimal.ONE) : variance.count();
        return variance.variance().divide(adjustedCount, MATH_CTX);
    }

    private BigDecimal toBigDecimal(T rawInput) {
        return new BigDecimal(rawInput.toString());
    }
}

