/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelCollation;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelCollationImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelFieldCollation;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Sort;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class BeamSortRel
extends Sort
implements BeamRelNode {
    private List<Integer> fieldIndices = new ArrayList<Integer>();
    private List<Boolean> orientation = new ArrayList<Boolean>();
    private List<Boolean> nullsFirst = new ArrayList<Boolean>();
    private int startIndex = 0;
    private int count;

    public BeamSortRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traits, child, collation, offset, fetch);
        List<RexNode> fieldExps = this.getChildExps();
        RelCollationImpl collationImpl = (RelCollationImpl)collation;
        List<RelFieldCollation> collations = collationImpl.getFieldCollations();
        for (int i = 0; i < fieldExps.size(); ++i) {
            RexNode fieldExp = fieldExps.get(i);
            RexInputRef inputRef = (RexInputRef)fieldExp;
            this.fieldIndices.add(inputRef.getIndex());
            this.orientation.add(collations.get(i).getDirection() == RelFieldCollation.Direction.ASCENDING);
            RelFieldCollation.NullDirection rawNullDirection = collations.get((int)i).nullDirection;
            if (rawNullDirection == RelFieldCollation.NullDirection.UNSPECIFIED) {
                rawNullDirection = collations.get(i).getDirection().defaultNullDirection();
            }
            this.nullsFirst.add(rawNullDirection == RelFieldCollation.NullDirection.FIRST);
        }
        if (fetch == null) {
            throw new UnsupportedOperationException("ORDER BY without a LIMIT is not supported!");
        }
        RexLiteral fetchLiteral = (RexLiteral)fetch;
        this.count = ((BigDecimal)fetchLiteral.getValue()).intValue();
        if (offset != null) {
            RexLiteral offsetLiteral = (RexLiteral)offset;
            this.startIndex = ((BigDecimal)offsetLiteral.getValue()).intValue();
        }
    }

    @Override
    public PTransform<PCollectionTuple, PCollection<Row>> toPTransform() {
        return new Transform();
    }

    @Override
    public Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new BeamSortRel(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
    }

    private static class BeamSqlRowComparator
    implements Comparator<Row>,
    Serializable {
        private List<Integer> fieldsIndices;
        private List<Boolean> orientation;
        private List<Boolean> nullsFirst;

        public BeamSqlRowComparator(List<Integer> fieldsIndices, List<Boolean> orientation, List<Boolean> nullsFirst) {
            this.fieldsIndices = fieldsIndices;
            this.orientation = orientation;
            this.nullsFirst = nullsFirst;
        }

        @Override
        public int compare(Row row1, Row row2) {
            for (int i = 0; i < this.fieldsIndices.size(); ++i) {
                boolean isValue2Null;
                int fieldIndex = this.fieldsIndices.get(i);
                int fieldRet = 0;
                SqlTypeName fieldType = CalciteUtils.getFieldCalciteType(row1.getRowType(), fieldIndex);
                boolean isValue1Null = row1.getValue(fieldIndex) == null;
                boolean bl = isValue2Null = row2.getValue(fieldIndex) == null;
                if (isValue1Null && isValue2Null) continue;
                if (isValue1Null && !isValue2Null) {
                    fieldRet = -1 * (this.nullsFirst.get(i) != false ? -1 : 1);
                } else if (!isValue1Null && isValue2Null) {
                    fieldRet = 1 * (this.nullsFirst.get(i) != false ? -1 : 1);
                } else {
                    switch (fieldType) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case FLOAT: 
                        case DOUBLE: 
                        case VARCHAR: 
                        case DATE: 
                        case TIMESTAMP: {
                            Comparable v1 = (Comparable)row1.getValue(fieldIndex);
                            Comparable v2 = (Comparable)row2.getValue(fieldIndex);
                            fieldRet = v1.compareTo(v2);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Data type: " + (Object)((Object)fieldType) + " not supported yet!");
                        }
                    }
                }
                if ((fieldRet *= this.orientation.get(i) != false ? -1 : 1) == 0) continue;
                return fieldRet;
            }
            return 0;
        }
    }

    private static class SubListFn<T>
    extends DoFn<List<T>, List<T>> {
        private int startIndex;
        private int endIndex;

        public SubListFn(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext ctx) {
            ctx.output(((List)ctx.element()).subList(this.startIndex, this.endIndex));
        }
    }

    private class Transform
    extends PTransform<PCollectionTuple, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionTuple inputPCollections) {
            RelNode input = BeamSortRel.this.getInput();
            PCollection upstream = (PCollection)inputPCollections.apply(BeamSqlRelUtils.getBeamRelInput(input).toPTransform());
            Type windowType = upstream.getWindowingStrategy().getWindowFn().getWindowTypeDescriptor().getType();
            if (!windowType.equals(GlobalWindow.class)) {
                throw new UnsupportedOperationException("`ORDER BY` is only supported for GlobalWindow, actual window: " + windowType);
            }
            BeamSqlRowComparator comparator = new BeamSqlRowComparator(BeamSortRel.this.fieldIndices, BeamSortRel.this.orientation, BeamSortRel.this.nullsFirst);
            PCollection rawStream = ((PCollection)upstream.apply("extractTopOffsetAndFetch", (PTransform)Top.of((int)(BeamSortRel.this.startIndex + BeamSortRel.this.count), (Comparator)comparator).withoutDefaults())).setCoder((Coder)ListCoder.of((Coder)upstream.getCoder()));
            if (BeamSortRel.this.startIndex > 0) {
                rawStream = ((PCollection)rawStream.apply("stripLeadingOffset", (PTransform)ParDo.of(new SubListFn(BeamSortRel.this.startIndex, BeamSortRel.this.startIndex + BeamSortRel.this.count)))).setCoder((Coder)ListCoder.of((Coder)upstream.getCoder()));
            }
            PCollection orderedStream = (PCollection)rawStream.apply("flatten", (PTransform)Flatten.iterables());
            orderedStream.setCoder((Coder)CalciteUtils.toBeamRowType(BeamSortRel.this.getRowType()).getRowCoder());
            return orderedStream;
        }
    }
}

