/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Joiner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.TableScan;

public class BeamIOSourceRel
extends TableScan
implements BeamRelNode {
    private BeamSqlEnv sqlEnv;

    public BeamIOSourceRel(BeamSqlEnv sqlEnv, RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table) {
        super(cluster, traitSet, table);
        this.sqlEnv = sqlEnv;
    }

    @Override
    public PTransform<PCollectionTuple, PCollection<Row>> toPTransform() {
        return new Transform();
    }

    private class Transform
    extends PTransform<PCollectionTuple, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionTuple inputPCollections) {
            String sourceName = Joiner.on('.').join(BeamIOSourceRel.this.getTable().getQualifiedName());
            TupleTag sourceTupleTag = new TupleTag(sourceName);
            if (inputPCollections.has(sourceTupleTag)) {
                PCollection sourceStream = inputPCollections.get(new TupleTag(sourceName));
                return sourceStream;
            }
            BeamSqlTable sourceTable = BeamIOSourceRel.this.sqlEnv.findTable(sourceName);
            return sourceTable.buildIOReader(inputPCollections.getPipeline()).setCoder((Coder)CalciteUtils.toBeamRowType(BeamIOSourceRel.this.getRowType()).getRowCoder());
        }
    }
}

