/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Joiner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.prepare.Prepare;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.TableModify;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;

public class BeamIOSinkRel
extends TableModify
implements BeamRelNode {
    private final BeamSqlEnv sqlEnv;

    public BeamIOSinkRel(BeamSqlEnv sqlEnv, RelOptCluster cluster, RelTraitSet traits, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
        super(cluster, traits, table, catalogReader, child, operation, updateColumnList, sourceExpressionList, flattened);
        this.sqlEnv = sqlEnv;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new BeamIOSinkRel(this.sqlEnv, this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), BeamIOSinkRel.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), this.isFlattened());
    }

    @Override
    public PTransform<PCollectionTuple, PCollection<Row>> toPTransform() {
        return new Transform();
    }

    private class Transform
    extends PTransform<PCollectionTuple, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionTuple inputPCollections) {
            RelNode input = BeamIOSinkRel.this.getInput();
            String stageName = BeamSqlRelUtils.getStageName(BeamIOSinkRel.this);
            PCollection upstream = (PCollection)inputPCollections.apply(BeamSqlRelUtils.getBeamRelInput(input).toPTransform());
            String sourceName = Joiner.on('.').join(BeamIOSinkRel.this.getTable().getQualifiedName());
            BeamSqlTable targetTable = BeamIOSinkRel.this.sqlEnv.findTable(sourceName);
            upstream.apply(stageName, targetTable.buildIOWriter());
            return upstream;
        }
    }
}

