/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret.ReinterpretConversion;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Optional;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class Reinterpreter {
    private Map<SqlTypeName, Map<SqlTypeName, ReinterpretConversion>> conversions;

    private Reinterpreter(Builder builder) {
        this.conversions = builder.conversions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean canConvert(SqlTypeName from, SqlTypeName to) {
        return this.getConversion(from, to).isPresent();
    }

    public BeamSqlPrimitive convert(SqlTypeName to, BeamSqlPrimitive value) {
        Optional<ReinterpretConversion> conversion = this.getConversion(value.getOutputType(), to);
        if (!conversion.isPresent()) {
            throw new UnsupportedOperationException("Unsupported conversion: " + value.getOutputType().name() + "->" + to.name());
        }
        return conversion.get().convert(value);
    }

    private Optional<ReinterpretConversion> getConversion(SqlTypeName from, SqlTypeName to) {
        if (!this.conversions.containsKey((Object)from)) {
            return Optional.absent();
        }
        Map<SqlTypeName, ReinterpretConversion> allConversionsFrom = this.conversions.get((Object)from);
        ReinterpretConversion conversionTo = allConversionsFrom.get((Object)to);
        return Optional.fromNullable(conversionTo);
    }

    public static class Builder {
        private Map<SqlTypeName, Map<SqlTypeName, ReinterpretConversion>> conversions = new HashMap<SqlTypeName, Map<SqlTypeName, ReinterpretConversion>>();

        public Builder withConversion(ReinterpretConversion conversion) {
            Set<SqlTypeName> fromTypes = conversion.from();
            SqlTypeName toType = conversion.to();
            for (SqlTypeName fromType : fromTypes) {
                if (!this.conversions.containsKey((Object)fromType)) {
                    this.conversions.put(fromType, new HashMap());
                }
                this.conversions.get((Object)fromType).put(toType, conversion);
            }
            return this;
        }

        public Reinterpreter build() {
            if (this.conversions.isEmpty()) {
                throw new IllegalArgumentException("Conversions should not be empty");
            }
            return new Reinterpreter(this);
        }
    }
}

