/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math;

import java.math.BigDecimal;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlMathUnaryExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.runtime.SqlFunctions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class BeamSqlAbsExpression
extends BeamSqlMathUnaryExpression {
    public BeamSqlAbsExpression(List<BeamSqlExpression> operands) {
        super(operands, operands.get(0).getOutputType());
    }

    @Override
    public BeamSqlPrimitive calculate(BeamSqlPrimitive op) {
        BeamSqlPrimitive<Number> result = null;
        switch (op.getOutputType()) {
            case INTEGER: {
                result = BeamSqlPrimitive.of(SqlTypeName.INTEGER, SqlFunctions.abs(op.getInteger()));
                break;
            }
            case BIGINT: {
                result = BeamSqlPrimitive.of(SqlTypeName.BIGINT, SqlFunctions.abs(op.getLong()));
                break;
            }
            case TINYINT: {
                result = BeamSqlPrimitive.of(SqlTypeName.TINYINT, SqlFunctions.abs(op.getByte()));
                break;
            }
            case SMALLINT: {
                result = BeamSqlPrimitive.of(SqlTypeName.SMALLINT, SqlFunctions.abs(op.getShort()));
                break;
            }
            case FLOAT: {
                result = BeamSqlPrimitive.of(SqlTypeName.FLOAT, Float.valueOf(SqlFunctions.abs(op.getFloat())));
                break;
            }
            case DECIMAL: {
                result = BeamSqlPrimitive.of(SqlTypeName.DECIMAL, SqlFunctions.abs(new BigDecimal(op.getValue().toString())));
                break;
            }
            case DOUBLE: {
                result = BeamSqlPrimitive.of(SqlTypeName.DOUBLE, SqlFunctions.abs(op.getDouble()));
                break;
            }
        }
        return result;
    }
}

