/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlDatetimeMinusExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.TimeUnitUtils;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.DateTime;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;

public class BeamSqlTimestampMinusTimestampExpression
extends BeamSqlExpression {
    private SqlTypeName intervalType;

    public BeamSqlTimestampMinusTimestampExpression(List<BeamSqlExpression> operands, SqlTypeName intervalType) {
        super(operands, SqlTypeName.BIGINT);
        this.intervalType = intervalType;
    }

    @Override
    public boolean accept() {
        return BeamSqlTimestampMinusTimestampExpression.accept(this.operands, this.intervalType);
    }

    static boolean accept(List<BeamSqlExpression> operands, SqlTypeName intervalType) {
        return BeamSqlDatetimeMinusExpression.INTERVALS_DURATIONS_TYPES.containsKey((Object)intervalType) && operands.size() == 2 && SqlTypeName.TIMESTAMP.equals((Object)operands.get(0).getOutputType()) && SqlTypeName.TIMESTAMP.equals((Object)operands.get(1).getOutputType());
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window) {
        DateTime timestampStart = new DateTime(this.opValueEvaluated(1, inputRow, window));
        DateTime timestampEnd = new DateTime(this.opValueEvaluated(0, inputRow, window));
        long numberOfIntervals = this.numberOfIntervalsBetweenDates(timestampStart, timestampEnd);
        long multiplier = TimeUnitUtils.timeUnitInternalMultiplier(this.intervalType).longValue();
        return BeamSqlPrimitive.of(SqlTypeName.BIGINT, multiplier * numberOfIntervals);
    }

    private long numberOfIntervalsBetweenDates(DateTime timestampStart, DateTime timestampEnd) {
        Period period = new Period((ReadableInstant)timestampStart, (ReadableInstant)timestampEnd, PeriodType.forFields((DurationFieldType[])new DurationFieldType[]{BeamSqlTimestampMinusTimestampExpression.durationFieldType(this.intervalType)}));
        return period.get(BeamSqlTimestampMinusTimestampExpression.durationFieldType(this.intervalType));
    }

    private static DurationFieldType durationFieldType(SqlTypeName intervalTypeToCount) {
        if (!BeamSqlDatetimeMinusExpression.INTERVALS_DURATIONS_TYPES.containsKey((Object)intervalTypeToCount)) {
            throw new IllegalArgumentException("Counting " + intervalTypeToCount.getName() + "s between dates is not supported");
        }
        return BeamSqlDatetimeMinusExpression.INTERVALS_DURATIONS_TYPES.get((Object)intervalTypeToCount);
    }
}

