/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlSelect;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.parser.SqlParseException;

class QueryValidationHelper {
    QueryValidationHelper() {
    }

    static void validateQuery(BeamSqlEnv sqlEnv, String queryString) {
        SqlNode sqlNode;
        try {
            sqlNode = sqlEnv.getPlanner().parseQuery(queryString);
            sqlEnv.getPlanner().getPlanner().close();
        }
        catch (SqlParseException e) {
            throw new IllegalStateException(e);
        }
        if (!(sqlNode instanceof SqlSelect)) {
            throw new UnsupportedOperationException("Sql operation " + sqlNode.toString() + " is not supported");
        }
        if (!"PCOLLECTION".equalsIgnoreCase(((SqlSelect)sqlNode).getFrom().toString())) {
            throw new IllegalStateException("Use PCOLLECTION as table name when selecting from single PCollection. Use PCollectionTuple to explicitly name the input PCollections");
        }
    }
}

