/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigtable;

import com.alibaba.fastjson.JSONObject;
import com.google.bigtable.v2.Row;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InvalidTableException;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableFilter;
import org.apache.beam.sdk.io.gcp.bigtable.BeamRowToBigtableMutation;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableRowToBeamRow;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableRowToBeamRowFlat;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

@Experimental
public class BigtableTable
extends SchemaBaseBeamTable
implements Serializable {
    private static final Pattern locationPattern = Pattern.compile("(?<host>.+)/bigtable/projects/(?<projectId>.+)/instances/(?<instanceId>.+)/tables/(?<tableId>.+)");
    private final String projectId;
    private final String instanceId;
    private final String tableId;
    private String emulatorHost = "";
    private boolean useFlatSchema = false;
    private Map<String, Set<String>> columnsMapping = Maps.newHashMap();

    BigtableTable(Table table) {
        super(table.getSchema());
        JSONObject properties;
        BigtableTable.validateSchema(this.schema);
        String location = table.getLocation();
        if (location == null) {
            throw new IllegalStateException("LOCATION is required");
        }
        Matcher matcher = locationPattern.matcher(location);
        BigtableTable.validateMatcher(matcher, location);
        this.projectId = BigtableTable.getMatcherValue(matcher, "projectId");
        this.instanceId = BigtableTable.getMatcherValue(matcher, "instanceId");
        this.tableId = BigtableTable.getMatcherValue(matcher, "tableId");
        String host = BigtableTable.getMatcherValue(matcher, "host");
        if (!"googleapis.com".equals(host)) {
            this.emulatorHost = host;
        }
        if ((properties = table.getProperties()).containsKey((Object)"columnsMapping")) {
            this.columnsMapping = BigtableTable.parseColumnsMapping(properties.getString("columnsMapping"));
            BigtableTable.validateColumnsMapping(this.columnsMapping, this.schema);
            this.useFlatSchema = true;
        }
    }

    @Override
    public PCollection<org.apache.beam.sdk.values.Row> buildIOReader(PBegin begin) {
        return ((PCollection)this.readTransform().expand(begin).apply("BigtableRowToBeamRow", this.bigtableRowToRow())).setRowSchema(this.schema);
    }

    @Override
    public PCollection<org.apache.beam.sdk.values.Row> buildIOReader(PBegin begin, BeamSqlTableFilter filters, List<String> fieldNames) {
        BigtableIO.Read readTransform = this.readTransform();
        if (filters instanceof BigtableFilter) {
            BigtableFilter bigtableFilter = (BigtableFilter)filters;
            readTransform = readTransform.withRowFilter(bigtableFilter.getFilters());
        }
        return (PCollection)readTransform.expand(begin).apply(this.bigtableRowToRow());
    }

    @Override
    public POutput buildIOWriter(PCollection<org.apache.beam.sdk.values.Row> input) {
        if (!this.useFlatSchema) {
            throw new UnsupportedOperationException("Write to Cloud Bigtable is supported for flat schema only.");
        }
        BigtableIO.Write write = BigtableIO.write().withProjectId(this.projectId).withInstanceId(this.instanceId).withTableId(this.tableId);
        if (!this.emulatorHost.isEmpty()) {
            write = write.withEmulator(this.emulatorHost);
        }
        return ((PCollection)input.apply((PTransform)new BeamRowToBigtableMutation(this.columnsMapping))).apply((PTransform)write);
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    @Override
    public BeamTableStatistics getTableStatistics(PipelineOptions options) {
        return BeamTableStatistics.BOUNDED_UNKNOWN;
    }

    @Override
    public BeamSqlTableFilter constructFilter(List<RexNode> filter) {
        return new BigtableFilter(filter, this.schema);
    }

    private static Map<String, Set<String>> parseColumnsMapping(String commaSeparatedMapping) {
        HashMap<String, Set<String>> columnsMapping = new HashMap<String, Set<String>>();
        Splitter.on((String)",").splitToList((CharSequence)commaSeparatedMapping).forEach(colonSeparatedValues -> {
            List pair = Splitter.on((String)":").splitToList((CharSequence)colonSeparatedValues);
            columnsMapping.putIfAbsent((String)pair.get(0), Sets.newHashSet());
            ((Set)columnsMapping.get(pair.get(0))).add((String)pair.get(1));
        });
        return columnsMapping;
    }

    private static String getMatcherValue(Matcher matcher, String field) {
        String value = matcher.group(field);
        return value == null ? "" : value;
    }

    private static void validateSchema(Schema schema) {
        if (!schema.hasField("key")) {
            throw new IllegalStateException(String.format("Schema has to contain '%s' field", "key"));
        }
        Schema.Field keyField = schema.getField("key");
        if (keyField != null && Schema.TypeName.STRING != keyField.getType().getTypeName()) {
            throw new IllegalArgumentException("key field type should be STRING but was " + keyField.getType().getTypeName());
        }
    }

    private static void validateMatcher(Matcher matcher, String location) {
        if (!matcher.matches()) {
            throw new InvalidTableException("Bigtable location must be in the following format: 'googleapis.com/bigtable/projects/projectId/instances/instanceId/tables/tableId' but was: " + location);
        }
    }

    private static void validateColumnsMapping(Map<String, Set<String>> columnsMapping, Schema schema) {
        BigtableTable.validateColumnsMappingCount(columnsMapping, schema);
        BigtableTable.validateColumnsMappingFields(columnsMapping, schema);
    }

    private static void validateColumnsMappingCount(Map<String, Set<String>> columnsMapping, Schema schema) {
        int mappingCount = columnsMapping.values().stream().mapToInt(Set::size).sum();
        int qualifiersCount = schema.getFieldCount() - 1;
        if (qualifiersCount != mappingCount) {
            throw new IllegalStateException(String.format("Schema fields count: '%s' does not fit columnsMapping count: '%s'", qualifiersCount, mappingCount));
        }
    }

    private static void validateColumnsMappingFields(Map<String, Set<String>> columnsMapping, Schema schema) {
        Set allMappingQualifiers = columnsMapping.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set schemaFieldNames = schema.getFieldNames().stream().filter(field -> !"key".equals(field)).collect(Collectors.toSet());
        if (!schemaFieldNames.equals(allMappingQualifiers)) {
            throw new IllegalStateException(String.format("columnsMapping '%s' does not fit to schema field names '%s'", allMappingQualifiers, schemaFieldNames));
        }
    }

    private BigtableIO.Read readTransform() {
        BigtableIO.Read readTransform = BigtableIO.read().withProjectId(this.projectId).withInstanceId(this.instanceId).withTableId(this.tableId);
        if (!this.emulatorHost.isEmpty()) {
            readTransform = readTransform.withEmulator(this.emulatorHost);
        }
        return readTransform;
    }

    private PTransform<PCollection<Row>, PCollection<org.apache.beam.sdk.values.Row>> bigtableRowToRow() {
        return this.useFlatSchema ? new BigtableRowToBeamRowFlat(this.schema, this.columnsMapping) : new BigtableRowToBeamRow(this.schema);
    }
}

