/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelCollation;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelDistribution;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Statistic;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.ImmutableBitSet;

@Experimental
@Internal
public class BeamTableStatistics
implements Serializable,
Statistic {
    public static final BeamTableStatistics BOUNDED_UNKNOWN = new BeamTableStatistics(100.0, 0.0, true);
    public static final BeamTableStatistics UNBOUNDED_UNKNOWN = new BeamTableStatistics(0.0, 0.1, true);
    private final boolean unknown;
    private final Double rowCount;
    private final Double rate;

    private BeamTableStatistics(Double rowCount, Double rate, boolean isUnknown) {
        this.rowCount = rowCount;
        this.rate = rate;
        this.unknown = isUnknown;
    }

    private BeamTableStatistics(Double rowCount, Double rate) {
        this(rowCount, rate, false);
    }

    public static BeamTableStatistics createBoundedTableStatistics(Double rowCount) {
        return new BeamTableStatistics(rowCount, 0.0);
    }

    public static BeamTableStatistics createUnboundedTableStatistics(Double rate) {
        return new BeamTableStatistics(0.0, rate);
    }

    public Double getRate() {
        return this.rate;
    }

    public boolean isUnknown() {
        return this.unknown;
    }

    public Double getRowCount() {
        return this.rowCount;
    }

    public boolean isKey(ImmutableBitSet columns) {
        return false;
    }

    public List<ImmutableBitSet> getKeys() {
        return Collections.emptyList();
    }

    public List<RelReferentialConstraint> getReferentialConstraints() {
        return ImmutableList.of();
    }

    public List<RelCollation> getCollations() {
        return ImmutableList.of();
    }

    public RelDistribution getDistribution() {
        return RelDistributionTraitDef.INSTANCE.getDefault();
    }
}

