/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.type.SqlTypeName;

public class TestTableFilter
implements BeamSqlTableFilter {
    private List<RexNode> supported = new ArrayList<RexNode>();
    private List<RexNode> unsupported = new ArrayList<RexNode>();

    public TestTableFilter(List<RexNode> predicateCNF) {
        for (RexNode node : predicateCNF) {
            if (this.isSupported(node)) {
                this.supported.add(node);
                continue;
            }
            this.unsupported.add(node);
        }
    }

    @Override
    public List<RexNode> getNotSupported() {
        return this.unsupported;
    }

    @Override
    public int numSupported() {
        return BeamSqlTableFilter.expressionsInFilter(this.supported);
    }

    public List<RexNode> getSupported() {
        return this.supported;
    }

    public String toString() {
        String supStr = "supported{" + this.supported.stream().map(RexNode::toString).collect(Collectors.joining()) + "}";
        String unsupStr = "unsupported{" + this.unsupported.stream().map(RexNode::toString).collect(Collectors.joining()) + "}";
        return "[" + supStr + ", " + unsupStr + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSupported(RexNode node) {
        if (!node.getType().getSqlTypeName().equals((Object)SqlTypeName.BOOLEAN)) throw new UnsupportedOperationException("Predicate node '" + node.getClass().getSimpleName() + "' should be a boolean expression, but was: " + node.getType().getSqlTypeName());
        if (node instanceof RexCall) {
            RexCall compositeNode = (RexCall)node;
            if (!node.getKind().belongsTo((Collection)SqlKind.COMPARISON)) {
                return false;
            }
            if (node.getKind().equals((Object)SqlKind.IN)) {
                return false;
            }
            for (RexNode operand : compositeNode.getOperands()) {
                if (operand instanceof RexLiteral || operand instanceof RexInputRef) continue;
                return false;
            }
            return true;
        } else {
            if (!(node instanceof RexInputRef)) throw new UnsupportedOperationException("Encountered an unexpected node type: " + node.getClass().getSimpleName());
            return true;
        }
    }
}

