/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rule;

import org.apache.beam.sdk.extensions.sql.impl.rel.CalcRelSplitter;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeamCalcSplittingRule
extends RelOptRule {
    private static final Logger LOG = LoggerFactory.getLogger(BeamCalcSplittingRule.class);

    protected BeamCalcSplittingRule(String description) {
        super(BeamCalcSplittingRule.operand(LogicalCalc.class, (RelOptRuleOperandChildren)BeamCalcSplittingRule.any()), RelFactories.LOGICAL_BUILDER, description);
    }

    public boolean matches(RelOptRuleCall x) {
        CalcRelSplitter.RelType[] relTypes = this.getRelTypes();
        for (RelNode relNode : x.getRelList()) {
            if (!(relNode instanceof LogicalCalc)) continue;
            LogicalCalc logicalCalc = (LogicalCalc)relNode;
            for (RexNode rexNode : logicalCalc.getProgram().getExprList()) {
                if (relTypes[0].canImplement(rexNode, false) || relTypes[1].canImplement(rexNode, false)) continue;
                LOG.error("Cannot implement expression {} with rule {}.", (Object)rexNode, (Object)this.description);
                return false;
            }
        }
        return true;
    }

    public void onMatch(RelOptRuleCall relOptRuleCall) {
        Calc calc = (Calc)relOptRuleCall.rel(0);
        CalcRelSplitter transform = new CalcRelSplitter(calc, relOptRuleCall.builder(), this.getRelTypes());
        RelNode newRel = transform.execute();
        relOptRuleCall.transformTo(newRel);
    }

    protected abstract CalcRelSplitter.RelType[] getRelTypes();
}

