/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStatsMetadata;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.metadata.RelMetadataQuery;

public class BeamSqlRelUtils {
    public static PCollection<Row> toPCollection(Pipeline pipeline, BeamRelNode node) {
        return BeamSqlRelUtils.toPCollection(pipeline, node, new HashMap<Integer, PCollection<Row>>());
    }

    private static PCollectionList<Row> buildPCollectionList(List<RelNode> inputRels, Pipeline pipeline, Map<Integer, PCollection<Row>> cache) {
        if (inputRels.isEmpty()) {
            return PCollectionList.empty((Pipeline)pipeline);
        }
        return PCollectionList.of((Iterable)inputRels.stream().map(input -> {
            BeamRelNode beamRel = input instanceof RelSubset ? (BeamRelNode)((RelSubset)input).getBest() : (BeamRelNode)input;
            return BeamSqlRelUtils.toPCollection(pipeline, beamRel, cache);
        }).collect(Collectors.toList()));
    }

    static PCollection<Row> toPCollection(Pipeline pipeline, BeamRelNode node, Map<Integer, PCollection<Row>> cache) {
        PCollection output = cache.get(node.getId());
        if (output != null) {
            return output;
        }
        String name = node.getClass().getSimpleName() + "_" + node.getId();
        PCollectionList<Row> input = BeamSqlRelUtils.buildPCollectionList(node.getPCollectionInputs(), pipeline, cache);
        PTransform<PCollectionList<Row>, PCollection<Row>> transform = node.buildPTransform();
        output = (PCollection)Pipeline.applyTransform((String)name, input, transform);
        cache.put(node.getId(), (PCollection<Row>)output);
        return output;
    }

    public static BeamRelNode getBeamRelInput(RelNode input) {
        if (input instanceof RelSubset) {
            input = ((RelSubset)input).getBest();
        }
        return (BeamRelNode)input;
    }

    public static RelNode getInput(RelNode input) {
        RelNode result = input;
        if (input instanceof RelSubset) {
            result = ((RelSubset)input).getBest();
            result = result == null ? ((RelSubset)input).getOriginal() : result;
        }
        return result;
    }

    public static NodeStats getNodeStats(RelNode input, RelMetadataQuery mq) {
        input = BeamSqlRelUtils.getInput(input);
        return ((NodeStatsMetadata)input.metadata(NodeStatsMetadata.class, mq)).getNodeStats();
    }
}

