/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSortRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexLocalRef;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexProgram;

@Internal
public abstract class AbstractBeamCalcRel
extends Calc
implements BeamRelNode {
    public AbstractBeamCalcRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RexProgram program) {
        super(cluster, traits, input, program);
    }

    public boolean isInputSortRelAndLimitOnly() {
        return this.input instanceof BeamSortRel && ((BeamSortRel)this.input).isLimitOnly();
    }

    public int getLimitCountOfSortRel() {
        if (this.input instanceof BeamSortRel) {
            return ((BeamSortRel)this.input).getCount();
        }
        throw new RuntimeException("Could not get the limit count from a non BeamSortRel input.");
    }

    @Override
    public NodeStats estimateNodeStats(RelMetadataQuery mq) {
        NodeStats inputStat = BeamSqlRelUtils.getNodeStats(this.input, mq);
        double selectivity = AbstractBeamCalcRel.estimateFilterSelectivity(this.getInput(), this.program, mq);
        return inputStat.multiply(selectivity);
    }

    private static double estimateFilterSelectivity(RelNode child, RexProgram program, RelMetadataQuery mq) {
        RexLocalRef programCondition = program.getCondition();
        RexNode condition = programCondition == null ? null : program.expandLocalRef(programCondition);
        return mq.getSelectivity(child, condition);
    }

    @Override
    public BeamCostModel beamComputeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        NodeStats inputStat = BeamSqlRelUtils.getNodeStats(this.input, mq);
        return BeamCostModel.FACTORY.makeCost(inputStat.getRowCount(), inputStat.getRate());
    }
}

