/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.cep;

import java.io.Serializable;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.RelFieldCollation;

public class OrderKey
implements Serializable {
    private final int fIndex;
    private final boolean dir;
    private final boolean nullFirst;

    private OrderKey(int fIndex, boolean dir, boolean nullFirst) {
        this.fIndex = fIndex;
        this.dir = dir;
        this.nullFirst = nullFirst;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public boolean getDir() {
        return this.dir;
    }

    public boolean getNullFirst() {
        return this.nullFirst;
    }

    public static OrderKey of(RelFieldCollation orderKey) {
        int fieldIndex = orderKey.getFieldIndex();
        RelFieldCollation.Direction dir = orderKey.direction;
        RelFieldCollation.NullDirection nullDir = orderKey.nullDirection;
        if (!dir.isDescending()) {
            if (nullDir == RelFieldCollation.NullDirection.FIRST) {
                return new OrderKey(fieldIndex, true, true);
            }
            return new OrderKey(fieldIndex, true, false);
        }
        if (nullDir == RelFieldCollation.NullDirection.FIRST) {
            return new OrderKey(fieldIndex, false, true);
        }
        return new OrderKey(fieldIndex, false, false);
    }
}

