/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlPipelineOptions;
import org.apache.beam.sdk.extensions.sql.impl.JavaUdfLoader;
import org.apache.beam.sdk.extensions.sql.impl.ScalarFunctionImpl;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamJavaTypeFactory;
import org.apache.beam.sdk.extensions.sql.impl.rel.AbstractBeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.DataContext;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.QueryProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Node;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Statement;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Types;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPredicateList;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexProgram;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexSimplify;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexUtil;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.runtime.SqlFunctions;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.validate.SqlConformance;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ScriptEvaluator;
import org.joda.time.DateTime;
import org.joda.time.Instant;

public class BeamCalcRel
extends AbstractBeamCalcRel {
    private static final long NANOS_PER_MILLISECOND = 1000000L;
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final ParameterExpression rowParam = Expressions.parameter(Row.class, (String)"row");
    private static final DataContext CONTEXT_INSTANCE = new SlimDataContext();

    public BeamCalcRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RexProgram program) {
        super(cluster, traits, input, program);
    }

    public Calc copy(RelTraitSet traitSet, RelNode input, RexProgram program) {
        return new BeamCalcRel(this.getCluster(), traitSet, input, program);
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    private static List<String> getJarPaths(RexProgram program) {
        ImmutableList.Builder jarPaths = new ImmutableList.Builder();
        for (RexNode node : program.getExprList()) {
            String jarPath;
            Function function;
            SqlOperator op;
            if (!(node instanceof RexCall) || !((op = ((RexCall)node).op) instanceof SqlUserDefinedFunction) || !((function = ((SqlUserDefinedFunction)op).function) instanceof ScalarFunctionImpl) || (jarPath = ((ScalarFunctionImpl)function).getJarPath()).isEmpty()) continue;
            jarPaths.add((Object)jarPath);
        }
        return jarPaths.build();
    }

    static Object toBeamObject(Object value, Schema.FieldType fieldType, boolean verifyValues) {
        if (value == null) {
            return null;
        }
        switch (fieldType.getTypeName()) {
            case BYTE: {
                return ((Number)value).byteValue();
            }
            case INT16: {
                return ((Number)value).shortValue();
            }
            case INT32: {
                return ((Number)value).intValue();
            }
            case INT64: {
                return ((Number)value).longValue();
            }
            case FLOAT: {
                return Float.valueOf(((Number)value).floatValue());
            }
            case DOUBLE: {
                return ((Number)value).doubleValue();
            }
            case DECIMAL: {
                if (value instanceof BigDecimal) {
                    return (BigDecimal)value;
                }
                if (value instanceof Long) {
                    return BigDecimal.valueOf((Long)value);
                }
                if (value instanceof Integer) {
                    return BigDecimal.valueOf(((Integer)value).intValue());
                }
                return new BigDecimal(((Number)value).toString());
            }
            case STRING: {
                return (String)value;
            }
            case BOOLEAN: {
                return (Boolean)value;
            }
            case DATETIME: {
                if (value instanceof Timestamp) {
                    value = SqlFunctions.toLong((Timestamp)((Timestamp)value));
                }
                return Instant.ofEpochMilli((long)((Number)value).longValue());
            }
            case BYTES: {
                if (value instanceof byte[]) {
                    return value;
                }
                return ((ByteString)value).getBytes();
            }
            case ARRAY: {
                return BeamCalcRel.toBeamList((List)value, fieldType.getCollectionElementType(), verifyValues);
            }
            case MAP: {
                return BeamCalcRel.toBeamMap((Map)value, fieldType.getMapKeyType(), fieldType.getMapValueType(), verifyValues);
            }
            case ROW: {
                if (value instanceof Object[]) {
                    value = Arrays.asList((Object[])value);
                }
                return BeamCalcRel.toBeamRow((List)value, fieldType.getRowSchema(), verifyValues);
            }
            case LOGICAL_TYPE: {
                String identifier = fieldType.getLogicalType().getIdentifier();
                if ("SqlCharType".equals(identifier)) {
                    return (String)value;
                }
                if ("SqlTimeWithLocalTzType".equals(identifier)) {
                    return Instant.ofEpochMilli((long)((Number)value).longValue());
                }
                if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                    if (value instanceof java.sql.Date) {
                        value = SqlFunctions.toInt((Date)((java.sql.Date)value));
                    }
                    return LocalDate.ofEpochDay(((Number)value).longValue());
                }
                if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                    if (value instanceof Time) {
                        value = SqlFunctions.toInt((Time)((Time)value));
                    }
                    return LocalTime.ofNanoOfDay(((Number)value).longValue() * 1000000L);
                }
                if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                    if (value instanceof Timestamp) {
                        value = SqlFunctions.toLong((Timestamp)((Timestamp)value));
                    }
                    return LocalDateTime.of(LocalDate.ofEpochDay(((Number)value).longValue() / 86400000L), LocalTime.ofNanoOfDay(((Number)value).longValue() % 86400000L * 1000000L));
                }
                throw new UnsupportedOperationException("Unable to convert logical type " + identifier);
            }
        }
        throw new UnsupportedOperationException("Unable to convert " + fieldType.getTypeName());
    }

    private static List<Object> toBeamList(List<Object> arrayValue, Schema.FieldType elementType, boolean verifyValues) {
        return arrayValue.stream().map(e -> BeamCalcRel.toBeamObject(e, elementType, verifyValues)).collect(Collectors.toList());
    }

    private static Map<Object, Object> toBeamMap(Map<Object, Object> mapValue, Schema.FieldType keyType, Schema.FieldType elementType, boolean verifyValues) {
        HashMap<Object, Object> output = new HashMap<Object, Object>(mapValue.size());
        for (Map.Entry<Object, Object> entry : mapValue.entrySet()) {
            output.put(BeamCalcRel.toBeamObject(entry.getKey(), keyType, verifyValues), BeamCalcRel.toBeamObject(entry.getValue(), elementType, verifyValues));
        }
        return output;
    }

    private static Row toBeamRow(List<Object> structValue, Schema schema, boolean verifyValues) {
        ArrayList<Object> objects = new ArrayList<Object>(schema.getFieldCount());
        assert (structValue.size() == schema.getFieldCount());
        for (int i = 0; i < structValue.size(); ++i) {
            objects.add(BeamCalcRel.toBeamObject(structValue.get(i), schema.getField(i).getType(), verifyValues));
        }
        Row row = verifyValues ? Row.withSchema((Schema)schema).addValues(objects).build() : Row.withSchema((Schema)schema).attachValues(objects);
        return row;
    }

    private static Expression nullOr(Expression field, Expression ifNotNull) {
        return Expressions.condition((Expression)Expressions.equal((Expression)field, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)Expressions.box((Expression)ifNotNull));
    }

    public static abstract class WrappedList<T>
    extends AbstractList<T> {
        private final List<Object> values;

        protected WrappedList(List<Object> values) {
            this.values = values;
        }

        @Override
        public T get(int index) {
            return this.value(this.values.get(index));
        }

        protected abstract T value(Object var1);

        @Override
        public int size() {
            return this.values.size();
        }
    }

    public static abstract class WrappedMap<V>
    extends AbstractMap<Object, V> {
        private final Map<Object, Object> map;

        protected WrappedMap(Map<Object, Object> map) {
            this.map = map;
        }

        @Override
        public Set<Map.Entry<Object, V>> entrySet() {
            return Maps.transformValues(this.map, val -> val == null ? null : this.value(val)).entrySet();
        }

        @Override
        public V get(Object key) {
            return this.value(this.map.get(key));
        }

        protected abstract V value(Object var1);
    }

    public static abstract class WrappedRow
    extends AbstractList<Object> {
        private final Row row;

        protected WrappedRow(Row row) {
            this.row = row;
        }

        @Override
        public Object get(int index) {
            return this.field(this.row, index);
        }

        protected abstract Object field(Row var1, int var2);

        @Override
        public int size() {
            return this.row.getFieldCount();
        }
    }

    private static class SlimDataContext
    implements DataContext {
        private SlimDataContext() {
        }

        public SchemaPlus getRootSchema() {
            return null;
        }

        public JavaTypeFactory getTypeFactory() {
            return null;
        }

        public QueryProvider getQueryProvider() {
            return null;
        }

        public Object get(String name) {
            if (name.equals(DataContext.Variable.UTC_TIMESTAMP.camelName) || name.equals(DataContext.Variable.CURRENT_TIMESTAMP.camelName) || name.equals(DataContext.Variable.LOCAL_TIMESTAMP.camelName)) {
                return System.currentTimeMillis();
            }
            if (name.equals(DataContext.Variable.TIME_ZONE.camelName)) {
                return TimeZone.getDefault();
            }
            return null;
        }
    }

    private static class InputGetterImpl
    implements RexToLixTranslator.InputGetter {
        private final Expression input;
        private final Schema inputSchema;

        private InputGetterImpl(Expression input, Schema inputSchema) {
            this.input = input;
            this.inputSchema = inputSchema;
        }

        public Expression field(BlockBuilder list, int index, Type storageType) {
            return InputGetterImpl.getBeamField(list, index, this.input, this.inputSchema);
        }

        private static Expression getBeamField(BlockBuilder list, int index, Expression input, Schema schema) {
            MethodCallExpression value;
            if (index >= schema.getFieldCount() || index < 0) {
                throw new IllegalArgumentException("Unable to find value #" + index);
            }
            Expression expression = list.append(list.newName("current"), input);
            Schema.FieldType fieldType = schema.getField(index).getType();
            switch (fieldType.getTypeName()) {
                case BYTE: {
                    value = Expressions.call((Expression)expression, (String)"getByte", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case INT16: {
                    value = Expressions.call((Expression)expression, (String)"getInt16", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case INT32: {
                    value = Expressions.call((Expression)expression, (String)"getInt32", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case INT64: {
                    value = Expressions.call((Expression)expression, (String)"getInt64", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case DECIMAL: {
                    value = Expressions.call((Expression)expression, (String)"getDecimal", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case FLOAT: {
                    value = Expressions.call((Expression)expression, (String)"getFloat", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case DOUBLE: {
                    value = Expressions.call((Expression)expression, (String)"getDouble", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case STRING: {
                    value = Expressions.call((Expression)expression, (String)"getString", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case DATETIME: {
                    value = Expressions.call((Expression)expression, (String)"getDateTime", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case BOOLEAN: {
                    value = Expressions.call((Expression)expression, (String)"getBoolean", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case BYTES: {
                    value = Expressions.call((Expression)expression, (String)"getBytes", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case ARRAY: {
                    value = Expressions.call((Expression)expression, (String)"getArray", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case MAP: {
                    value = Expressions.call((Expression)expression, (String)"getMap", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case ROW: {
                    value = Expressions.call((Expression)expression, (String)"getRow", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                    break;
                }
                case LOGICAL_TYPE: {
                    String identifier = fieldType.getLogicalType().getIdentifier();
                    if ("SqlCharType".equals(identifier)) {
                        value = Expressions.call((Expression)expression, (String)"getString", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                        break;
                    }
                    if ("SqlTimeWithLocalTzType".equals(identifier)) {
                        value = Expressions.call((Expression)expression, (String)"getDateTime", (Expression[])new Expression[]{Expressions.constant((Object)index)});
                        break;
                    }
                    if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                        value = Expressions.convert_((Expression)Expressions.call((Expression)expression, (String)"getLogicalTypeValue", (Expression[])new Expression[]{Expressions.constant((Object)index), Expressions.constant(LocalDate.class)}), LocalDate.class);
                        break;
                    }
                    if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                        value = Expressions.convert_((Expression)Expressions.call((Expression)expression, (String)"getLogicalTypeValue", (Expression[])new Expression[]{Expressions.constant((Object)index), Expressions.constant(LocalTime.class)}), LocalTime.class);
                        break;
                    }
                    if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                        value = Expressions.convert_((Expression)Expressions.call((Expression)expression, (String)"getLogicalTypeValue", (Expression[])new Expression[]{Expressions.constant((Object)index), Expressions.constant(LocalDateTime.class)}), LocalDateTime.class);
                        break;
                    }
                    throw new UnsupportedOperationException("Unable to get logical type " + identifier);
                }
                default: {
                    throw new UnsupportedOperationException("Unable to get " + fieldType.getTypeName());
                }
            }
            return InputGetterImpl.toCalciteValue((Expression)value, fieldType);
        }

        private static Expression toCalciteValue(Expression value, Schema.FieldType fieldType) {
            switch (fieldType.getTypeName()) {
                case BYTE: {
                    return Expressions.convert_((Expression)value, Byte.class);
                }
                case INT16: {
                    return Expressions.convert_((Expression)value, Short.class);
                }
                case INT32: {
                    return Expressions.convert_((Expression)value, Integer.class);
                }
                case INT64: {
                    return Expressions.convert_((Expression)value, Long.class);
                }
                case DECIMAL: {
                    return Expressions.convert_((Expression)value, BigDecimal.class);
                }
                case FLOAT: {
                    return Expressions.convert_((Expression)value, Float.class);
                }
                case DOUBLE: {
                    return Expressions.convert_((Expression)value, Double.class);
                }
                case STRING: {
                    return Expressions.convert_((Expression)value, String.class);
                }
                case BOOLEAN: {
                    return Expressions.convert_((Expression)value, Boolean.class);
                }
                case DATETIME: {
                    return BeamCalcRel.nullOr(value, (Expression)Expressions.call((Expression)Expressions.convert_((Expression)value, DateTime.class), (String)"getMillis", (Expression[])new Expression[0]));
                }
                case BYTES: {
                    return BeamCalcRel.nullOr(value, (Expression)Expressions.new_(ByteString.class, (Expression[])new Expression[]{Expressions.convert_((Expression)value, byte[].class)}));
                }
                case ARRAY: {
                    return BeamCalcRel.nullOr(value, InputGetterImpl.toCalciteList(value, fieldType.getCollectionElementType()));
                }
                case MAP: {
                    return BeamCalcRel.nullOr(value, InputGetterImpl.toCalciteMap(value, fieldType.getMapValueType()));
                }
                case ROW: {
                    return BeamCalcRel.nullOr(value, InputGetterImpl.toCalciteRow(value, fieldType.getRowSchema()));
                }
                case LOGICAL_TYPE: {
                    String identifier = fieldType.getLogicalType().getIdentifier();
                    if ("SqlCharType".equals(identifier)) {
                        return Expressions.convert_((Expression)value, String.class);
                    }
                    if ("SqlTimeWithLocalTzType".equals(identifier)) {
                        return BeamCalcRel.nullOr(value, (Expression)Expressions.call((Expression)Expressions.convert_((Expression)value, DateTime.class), (String)"getMillis", (Expression[])new Expression[0]));
                    }
                    if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                        return BeamCalcRel.nullOr(value, (Expression)Expressions.call((Expression)Expressions.box((Expression)Expressions.call((Expression)Expressions.convert_((Expression)value, LocalDate.class), (String)"toEpochDay", (Expression[])new Expression[0])), (String)"intValue", (Expression[])new Expression[0]));
                    }
                    if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                        return BeamCalcRel.nullOr(value, (Expression)Expressions.call((Expression)Expressions.box((Expression)Expressions.divide((Expression)Expressions.call((Expression)Expressions.convert_((Expression)value, LocalTime.class), (String)"toNanoOfDay", (Expression[])new Expression[0]), (Expression)Expressions.constant((Object)1000000L))), (String)"intValue", (Expression[])new Expression[0]));
                    }
                    if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                        value = Expressions.convert_((Expression)value, LocalDateTime.class);
                        MethodCallExpression dateValue = Expressions.call((Expression)Expressions.call((Expression)value, (String)"toLocalDate", (Expression[])new Expression[0]), (String)"toEpochDay", (Expression[])new Expression[0]);
                        MethodCallExpression timeValue = Expressions.call((Expression)Expressions.call((Expression)value, (String)"toLocalTime", (Expression[])new Expression[0]), (String)"toNanoOfDay", (Expression[])new Expression[0]);
                        BinaryExpression returnValue = Expressions.add((Expression)Expressions.multiply((Expression)dateValue, (Expression)Expressions.constant((Object)86400000L)), (Expression)Expressions.divide((Expression)timeValue, (Expression)Expressions.constant((Object)1000000L)));
                        return BeamCalcRel.nullOr(value, (Expression)returnValue);
                    }
                    throw new UnsupportedOperationException("Unable to convert logical type " + identifier);
                }
            }
            throw new UnsupportedOperationException("Unable to convert " + fieldType.getTypeName());
        }

        private static Expression toCalciteList(Expression input, Schema.FieldType elementType) {
            ParameterExpression value = Expressions.parameter(Object.class);
            BlockBuilder block = new BlockBuilder();
            block.add(InputGetterImpl.toCalciteValue((Expression)value, elementType));
            return Expressions.new_(WrappedList.class, (Iterable)ImmutableList.of((Object)Types.castIfNecessary(List.class, (Expression)input)), (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, Object.class, (String)"value", (Iterable)ImmutableList.of((Object)value), (BlockStatement)block.toBlock())));
        }

        private static Expression toCalciteMap(Expression input, Schema.FieldType mapValueType) {
            ParameterExpression value = Expressions.parameter(Object.class);
            BlockBuilder block = new BlockBuilder();
            block.add(InputGetterImpl.toCalciteValue((Expression)value, mapValueType));
            return Expressions.new_(WrappedMap.class, (Iterable)ImmutableList.of((Object)Types.castIfNecessary(Map.class, (Expression)input)), (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, Object.class, (String)"value", (Iterable)ImmutableList.of((Object)value), (BlockStatement)block.toBlock())));
        }

        private static Expression toCalciteRow(Expression input, Schema schema) {
            ParameterExpression row = Expressions.parameter(Row.class);
            ParameterExpression index = Expressions.parameter(Integer.TYPE);
            BlockBuilder body = new BlockBuilder(false);
            for (int i = 0; i < schema.getFieldCount(); ++i) {
                BlockBuilder list = new BlockBuilder(false, body);
                Expression returnValue = InputGetterImpl.getBeamField(list, i, (Expression)row, schema);
                list.append(returnValue);
                body.append("if i=" + i, Expressions.block((Statement[])new Statement[]{Expressions.ifThen((Expression)Expressions.equal((Expression)index, (Expression)Expressions.constant((Object)i, Integer.TYPE)), (Node)list.toBlock())}));
            }
            body.add((Statement)Expressions.throw_((Expression)Expressions.new_(IndexOutOfBoundsException.class)));
            return Expressions.new_(WrappedRow.class, (Iterable)ImmutableList.of((Object)Types.castIfNecessary(Row.class, (Expression)input)), (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, Object.class, (String)"field", (Iterable)ImmutableList.of((Object)row, (Object)index), (BlockStatement)body.toBlock())));
        }
    }

    private static class CalcFn
    extends DoFn<Row, Row> {
        private final String processElementBlock;
        private final Schema outputSchema;
        private final boolean verifyRowValues;
        private final List<String> jarPaths;
        private transient @Nullable ScriptEvaluator se = null;

        public CalcFn(String processElementBlock, Schema outputSchema, boolean verifyRowValues, List<String> jarPaths) {
            this.processElementBlock = processElementBlock;
            this.outputSchema = outputSchema;
            this.verifyRowValues = verifyRowValues;
            this.jarPaths = jarPaths;
        }

        ScriptEvaluator compile() {
            ScriptEvaluator se = new ScriptEvaluator();
            if (!this.jarPaths.isEmpty()) {
                try {
                    JavaUdfLoader udfLoader = new JavaUdfLoader();
                    ClassLoader classLoader = udfLoader.createClassLoader(this.jarPaths);
                    se.setParentClassLoader(classLoader);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load user-provided jar(s).", e);
                }
            }
            se.setParameters(new String[]{rowParam.name, DataContext.ROOT.name}, new Class[]{(Class)rowParam.getType(), (Class)DataContext.ROOT.getType()});
            se.setReturnType(Object[].class);
            try {
                se.cook(this.processElementBlock);
            }
            catch (CompileException e) {
                throw new UnsupportedOperationException("Could not compile CalcFn: " + this.processElementBlock, e);
            }
            return se;
        }

        @DoFn.Setup
        public void setup() {
            this.se = this.compile();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            Object[] v;
            assert (this.se != null);
            try {
                v = (Object[])this.se.evaluate(new Object[]{c.element(), CONTEXT_INSTANCE});
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("CalcFn failed to evaluate: " + this.processElementBlock, e.getCause());
            }
            if (v != null) {
                Row row = BeamCalcRel.toBeamRow(Arrays.asList(v), this.outputSchema, this.verifyRowValues);
                c.output((Object)row);
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"Wrong number of inputs for %s: %s", (Object[])new Object[]{BeamCalcRel.class.getSimpleName(), pinput});
            PCollection upstream = pinput.get(0);
            Schema outputSchema = CalciteUtils.toSchema(BeamCalcRel.this.getRowType());
            SqlConformanceEnum conformance = SqlConformanceEnum.MYSQL_5;
            JavaTypeFactory typeFactory = BeamJavaTypeFactory.INSTANCE;
            BlockBuilder builder = new BlockBuilder();
            PhysType physType = PhysTypeImpl.of((JavaTypeFactory)typeFactory, (RelDataType)BeamCalcRel.this.getRowType(), (JavaRowFormat)JavaRowFormat.ARRAY, (boolean)false);
            RexBuilder rexBuilder = BeamCalcRel.this.getCluster().getRexBuilder();
            RelMetadataQuery mq = RelMetadataQuery.instance();
            RelOptPredicateList predicates = mq.getPulledUpPredicates(BeamCalcRel.this.getInput());
            RexSimplify simplify = new RexSimplify(rexBuilder, predicates, RexUtil.EXECUTOR);
            RexProgram program = BeamCalcRel.this.getProgram().normalize(rexBuilder, simplify);
            Expression condition = RexToLixTranslator.translateCondition((RexProgram)program, (JavaTypeFactory)typeFactory, (BlockBuilder)builder, (RexToLixTranslator.InputGetter)new InputGetterImpl((Expression)rowParam, upstream.getSchema()), null, (SqlConformance)conformance);
            List expressions = RexToLixTranslator.translateProjects((RexProgram)program, (JavaTypeFactory)typeFactory, (SqlConformance)conformance, (BlockBuilder)builder, (PhysType)physType, (Expression)DataContext.ROOT, (RexToLixTranslator.InputGetter)new InputGetterImpl((Expression)rowParam, upstream.getSchema()), null);
            builder.add((Statement)Expressions.ifThenElse((Expression)condition, (Node)Expressions.return_(null, (Expression)physType.record(expressions)), (Node)Expressions.return_(null, (Expression)Expressions.constant(null))));
            BeamSqlPipelineOptions options = (BeamSqlPipelineOptions)pinput.getPipeline().getOptions().as(BeamSqlPipelineOptions.class);
            CalcFn calcFn = new CalcFn(builder.toBlock().toString(), outputSchema, options.getVerifyRowValues(), BeamCalcRel.getJarPaths(program));
            calcFn.compile();
            return ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)calcFn))).setRowSchema(outputSchema);
        }
    }
}

